/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.name;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.webimage.name.NamingConventionUtil;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.webimage.JSNameGenerator;
import com.oracle.svm.webimage.NamingConvention;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class WebImageNamingConvention
implements NamingConvention {
    private final NamingMode mode;
    private final NamingConvention instance;
    public static WebImageNamingConvention singletonInstance;
    public static final String FieldPrefix = "";

    public static void initialize() {
        GraalError.guarantee((singletonInstance == null ? 1 : 0) != 0, (String)"A naming convention instance has already been created");
        singletonInstance = new WebImageNamingConvention((NamingMode)((Object)WebImageOptions.NamingConvention.getValue(HostedOptionValues.singleton())));
    }

    public static WebImageNamingConvention getInstance() {
        GraalError.guarantee((singletonInstance != null ? 1 : 0) != 0, (String)"A naming convention instance has not been created yet");
        return singletonInstance;
    }

    public static void clear() {
        singletonInstance = null;
    }

    private WebImageNamingConvention(NamingMode mode) {
        this.mode = mode;
        switch (mode.ordinal()) {
            case 0: {
                this.instance = new MinifiedNamingConvention();
                break;
            }
            case 1: {
                this.instance = new ReducedNamingConvention();
                break;
            }
            case 2: {
                this.instance = new FullNamingConvention();
                break;
            }
            default: {
                throw JVMCIError.shouldNotReachHere();
            }
        }
    }

    public NamingMode mode() {
        return this.mode;
    }

    @Override
    public String identForType(ResolvedJavaType t) {
        return this.instance.identForType(t);
    }

    @Override
    public String identForMethod(ResolvedJavaMethod m) {
        return this.instance.identForMethod(m);
    }

    @Override
    public String identForProperty(ResolvedJavaField field) {
        return this.instance.identForProperty(field);
    }

    @Override
    public String identForArtificialProperty(String name, ResolvedJavaType type) {
        return this.instance.identForArtificialProperty(name, type);
    }

    public static enum NamingMode {
        MINIMAL,
        REDUCED,
        FULL;

    }

    static class MinifiedNamingConvention
    extends FullNamingConvention {
        private final JSNameGenerator.NameCache<String> nameCache = new JSNameGenerator.NameCache("$");

        MinifiedNamingConvention() {
        }

        private String queryCache(String identifier) {
            return this.nameCache.get(identifier);
        }

        @Override
        public String identForType(ResolvedJavaType t) {
            return this.queryCache(super.identForType(t));
        }

        @Override
        public String identForMethod(ResolvedJavaMethod m) {
            return this.queryCache(super.identForMethod(m));
        }

        @Override
        public String identForArtificialProperty(String name, ResolvedJavaType type) {
            return this.queryCache(super.identForArtificialProperty(name, type));
        }
    }

    static class ReducedNamingConvention
    implements NamingConvention {
        private final ConcurrentMap<String, String> typeIdent = new ConcurrentHashMap<String, String>();

        ReducedNamingConvention() {
        }

        @Override
        public String identForType(ResolvedJavaType t) {
            String name = t.getName();
            String reducedName = "_" + NamingConventionUtil.cleanTypeName(t.getUnqualifiedName());
            String oldName = this.typeIdent.putIfAbsent(reducedName, name);
            if (oldName == null || oldName.equals(name)) {
                return reducedName;
            }
            return NamingConventionUtil.formatClassName(t);
        }

        @Override
        public String identForMethod(ResolvedJavaMethod m) {
            return NamingConventionUtil.formatVMFunctionName(m, this);
        }

        @Override
        public String identForArtificialProperty(String name, ResolvedJavaType type) {
            return name + "_" + this.identForType(type);
        }

        @Override
        public String identForStaticProperty(String name, ResolvedJavaType type) {
            return name + "_";
        }
    }

    static class FullNamingConvention
    implements NamingConvention {
        FullNamingConvention() {
        }

        @Override
        public String identForType(ResolvedJavaType t) {
            return NamingConventionUtil.formatClassName(t);
        }

        @Override
        public String identForMethod(ResolvedJavaMethod m) {
            return NamingConventionUtil.formatVMFunctionName(m, this);
        }

        @Override
        public String identForArtificialProperty(String name, ResolvedJavaType type) {
            return name + "_" + this.identForType(type);
        }
    }
}

