/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.name;

import com.oracle.svm.webimage.NamingConvention;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.SourceVersion;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class NamingConventionUtil {
    private static final String CONSTRUCTOR_SAFE_JS_NAME = "strictfp";
    private static final String CLASS_INITIALIZER = "volatile";

    public static String formatClassName(ResolvedJavaType type) {
        assert (type != null);
        String className = type.getName();
        if (className.length() == 0) {
            JVMCIError.shouldNotReachHere((String)("Class names must have pos length -->" + className));
        }
        return NamingConventionUtil.cleanTypeName(className);
    }

    public static String formatVMFunctionName(ResolvedJavaMethod m, NamingConvention conv) {
        StringBuilder sb = new StringBuilder();
        Signature sig = m.getSignature();
        for (int i = 0; i < sig.getParameterCount(false); ++i) {
            JavaType t = sig.getParameterType(i, null);
            if (t instanceof ResolvedJavaType) {
                sb.append(conv.identForType((ResolvedJavaType)t));
                continue;
            }
            sb.append(NamingConventionUtil.cleanTypeName(t.getName()));
        }
        JavaType t = sig.getReturnType(null);
        if (t instanceof ResolvedJavaType) {
            sb.append(conv.identForType((ResolvedJavaType)t));
        } else {
            sb.append(NamingConventionUtil.cleanTypeName(t.getName()));
        }
        sb.insert(0, "__");
        String name = m.getName();
        switch (name = name.replace("*", "_")) {
            case "<init>": {
                name = CONSTRUCTOR_SAFE_JS_NAME;
                break;
            }
            case "<clinit>": {
                name = CLASS_INITIALIZER;
            }
        }
        sb.insert(0, name);
        if (!SourceVersion.isName(name)) {
            sb.insert(0, "__");
        }
        return sb.toString();
    }

    public static String cleanTypeName(String name) {
        int index;
        StringBuilder sb = new StringBuilder(name);
        while ((index = sb.indexOf("/")) != -1) {
            sb.replace(index, index + 1, "_");
        }
        while ((index = sb.indexOf("[")) != -1) {
            sb.replace(index, index + 1, "$");
        }
        while ((index = sb.indexOf(".")) != -1) {
            sb.replace(index, index + 1, "_");
        }
        while ((index = sb.indexOf(";")) != -1) {
            sb.replace(index, index + 1, "_");
        }
        return sb.toString();
    }

    public static List<String> splitClassDesc(String desc) {
        String ww = desc.replace(" ", "");
        ww = ww.replace(";", "");
        ww = ww.replace("L", "");
        if (desc.contains(".")) {
            JVMCIError.shouldNotReachHere((String)"Unknown type name specifier");
        }
        String[] idents = ww.split("/");
        return Arrays.asList(idents);
    }
}

