/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.metrickeys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.MetricKey;

public class ImageBreakdownMetricKeys {
    public static final MetricKey ENTIRE_IMAGE_SIZE = DebugContext.counter((CharSequence)"entire-image-size");
    public static final MetricKey JS_IMAGE_SIZE = DebugContext.counter((CharSequence)"js-image-size");
    public static final MetricKey WASM_IMAGE_SIZE = DebugContext.counter((CharSequence)"wasm-image-size");
    public static final MetricKey INITIAL_DEFINITIONS_SIZE = DebugContext.counter((CharSequence)"initial-definitions-size");
    public static final MetricKey STATIC_FIELDS_SIZE = DebugContext.counter((CharSequence)"static-fields-size");
    public static final MetricKey TYPE_DECLARATIONS_SIZE = DebugContext.counter((CharSequence)"type-declarations-size");
    public static final MetricKey EXTRA_DEFINITIONS_SIZE = DebugContext.counter((CharSequence)"extra-definitions-size");
    public static final MetricKey CONSTANTS_SIZE = DebugContext.counter((CharSequence)"constants-size");
    public static final MetricKey CONSTANT_DEFS_SIZE = DebugContext.counter((CharSequence)"constant-definitions-size");
    public static final MetricKey CONSTANT_INITS_SIZE = DebugContext.counter((CharSequence)"constant-initializations-size");
    public static final MetricKey TOTAL_METHOD_SIZE = DebugContext.counter((CharSequence)"total-method-size");
    public static final MetricKey RECONSTRUCTED_SIZE = DebugContext.counter((CharSequence)"reconstructed-method-size");
    public static final MetricKey NO_CF_SIZE = DebugContext.counter((CharSequence)"no-control-flow-method-size");
    public static final List<MetricKey> CONSTANT_SIZE_CLASSES;

    static {
        ArrayList<CounterKey> sizeClasses = new ArrayList<CounterKey>();
        for (int i = 0; i < 31; ++i) {
            sizeClasses.add(DebugContext.counter((CharSequence)("constant-size-class-" + i)));
        }
        CONSTANT_SIZE_CLASSES = Collections.unmodifiableList(sizeClasses);
    }
}

