/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;

public interface Widget {
    public static final char NEWLINE = '\n';
    public static final char TOP_LEFT_CORNER = '\u250c';
    public static final char TOP_RIGHT_CORNER = '\u2510';
    public static final char BOTTOM_LEFT_CORNER = '\u2514';
    public static final char BOTTOM_RIGHT_CORNER = '\u2518';
    public static final char VERTICAL_BORDER = '\u2502';
    public static final char HORIZONTAL_BORDER = '\u2500';
    public static final char LEFT_T_BAR = '\u2524';
    public static final char RIGHT_T_BAR = '\u251c';

    public void visualize(DrawKit var1);

    public static void repeat(DrawKit kit, int maxLabelWidth, char c) {
        for (int i = 0; i < maxLabelWidth; ++i) {
            kit.print(c);
        }
    }

    public static String trunc(String s, int maxLength) {
        if (s.length() > maxLength) {
            return s.substring(0, maxLength - 3) + "...";
        }
        return s;
    }

    public static String hardTrunc(String s, int maxLength) {
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static String pad(String s, int maxLength, boolean left) {
        if (s.length() >= maxLength) {
            return s;
        }
        StringBuilder padding = new StringBuilder(maxLength - s.length());
        for (int i = 0; i < maxLength - s.length(); ++i) {
            padding.append(' ');
        }
        return left ? String.valueOf(padding) + s : s + String.valueOf(padding);
    }

    public static String center(String s, int length) {
        if (s.length() >= length) {
            return s;
        }
        int remaining = length - s.length();
        return Widget.pad(Widget.pad(s, s.length() + remaining / 2, true), length, false);
    }
}

