/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;
import java.util.LinkedHashMap;
import java.util.Map;

public class SummaryWidget
implements Widget {
    private final LinkedHashMap<String, String> info;

    public SummaryWidget(LinkedHashMap<String, String> info) {
        this.info = info;
    }

    @Override
    public void visualize(DrawKit kit) {
        int maxKeyLength = 0;
        for (String string : this.info.keySet()) {
            maxKeyLength = Math.max(string.length(), maxKeyLength);
        }
        for (Map.Entry entry : this.info.entrySet()) {
            kit.print(' ');
            kit.print(Widget.pad((String)entry.getKey() + ":", maxKeyLength + 2, false));
            kit.println((String)entry.getValue());
        }
    }
}

