/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.Color;
import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.VisualizationSupport;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class StackedBarWidget
implements Widget {
    private static final int MIN_WIDTH = 40;
    private static final Character[] MONOCHROME_BAR_GLYPH_WHEEL = new Character[]{Character.valueOf('\u2588'), Character.valueOf('\u2593'), Character.valueOf('\u2592'), Character.valueOf('\u2591')};
    private final Map<String, Number> breakdown;
    private final String unit;
    private final Number totalValue;
    private final int multiplier;
    private final Map<String, Color> colors;

    public StackedBarWidget(Map<String, Number> breakdown, Number totalValue, String unit, int multiplier, Map<String, Color> colors) {
        this.breakdown = breakdown;
        this.totalValue = totalValue;
        this.unit = unit;
        this.multiplier = multiplier;
        this.colors = colors;
    }

    @Override
    public void visualize(DrawKit kit) {
        int i;
        if (kit.width() < 40) {
            kit.println(Widget.trunc("(too narrow console)", kit.width()));
            kit.println();
            return;
        }
        if (this.breakdown.values().stream().allMatch(value -> value.doubleValue() == 0.0)) {
            kit.println(String.format("Total:  %.2f %s", this.totalValue.doubleValue() / (double)this.multiplier, this.unit));
            return;
        }
        int barWidth = kit.width() - 4;
        if (this.breakdown.size() > barWidth) {
            kit.println(Widget.trunc("(too narrow console)", kit.width()));
            kit.println();
            return;
        }
        double valueSum = 0.0;
        for (Number value2 : this.breakdown.values()) {
            valueSum += value2.doubleValue() / (double)this.multiplier;
        }
        HashMap<String, Integer> tileCount = new HashMap<String, Integer>();
        double remainingValueSum = valueSum;
        int remainingBarWidth = barWidth;
        List sortedEntries = this.breakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingDouble(Number::doubleValue))).collect(Collectors.toList());
        for (Map.Entry entry : sortedEntries) {
            double value3 = ((Number)entry.getValue()).doubleValue() / (double)this.multiplier;
            int count = (int)(value3 / remainingValueSum * (double)remainingBarWidth + 0.5);
            if (count == 0) {
                count = 1;
            }
            tileCount.put((String)entry.getKey(), count);
            remainingBarWidth -= count;
            remainingValueSum -= value3;
        }
        int tickLength = 16;
        kit.print(Widget.pad(Widget.trunc(" 0.00 " + this.unit, tickLength), tickLength, false));
        for (i = tickLength; i < kit.width() - tickLength; ++i) {
            kit.print(' ');
        }
        kit.print(Widget.pad(Widget.trunc(String.format("%.2f %s", valueSum, this.unit), tickLength), tickLength, true));
        kit.println();
        kit.print(" \u2570");
        for (i = 0; i < kit.width() - 4; ++i) {
            if (i % 4 == 0) {
                kit.print('\u252c');
                continue;
            }
            kit.print('\u2500');
        }
        kit.print("\u256f ");
        kit.println();
        if (((Boolean)VisualizationSupport.Options.CLIVisualizationMonochrome.getValue()).booleanValue()) {
            this.visualizeBar(kit, tileCount, (entryIndex, c) -> Character.valueOf(StackedBarWidget.monochromeCharacter(entryIndex)));
        } else {
            this.visualizeBar(kit, tileCount, (entryIndex, c) -> Character.valueOf('\u2585'));
            this.visualizeBar(kit, tileCount, (entryIndex, c) -> Character.valueOf('\u2580'));
        }
        LinkedHashMap<String, String> legendEntries = new LinkedHashMap<String, String>();
        this.visualizeCategoryLabels(kit, tileCount, legendEntries, true);
        this.visualizeCategoryLabels(kit, tileCount, legendEntries, false);
        int entryIndex2 = 0;
        for (Map.Entry entry : legendEntries.entrySet()) {
            String key = (String)entry.getKey();
            String value4 = (String)entry.getValue();
            kit.print(' ');
            if (((Boolean)VisualizationSupport.Options.CLIVisualizationMonochrome.getValue()).booleanValue()) {
                kit.print(StackedBarWidget.monochromeCharacter(entryIndex2));
            } else {
                kit.color(this.colors.get(key));
                kit.print('\u25fc');
                kit.color(Color.RESET);
            }
            kit.print(String.format(" %s (%s)", key, value4));
            kit.println();
            ++entryIndex2;
        }
        kit.println(String.format("Total:  %.2f %s", this.totalValue.doubleValue() / (double)this.multiplier, this.unit));
        kit.println(String.format("Unacc.: %.2f %s", this.totalValue.doubleValue() / (double)this.multiplier - valueSum, this.unit));
    }

    private static char monochromeCharacter(Integer entryIndex) {
        return MONOCHROME_BAR_GLYPH_WHEEL[entryIndex % MONOCHROME_BAR_GLYPH_WHEEL.length].charValue();
    }

    private void visualizeCategoryLabels(DrawKit kit, HashMap<String, Integer> tileCount, Map<String, String> legendEntries, boolean drawKey) {
        for (Map.Entry<String, Number> entry : this.breakdown.entrySet()) {
            String key = entry.getKey();
            int count = tileCount.get(key);
            String value = String.format("%.2f %s", entry.getValue().doubleValue() / (double)this.multiplier, this.unit);
            int minLength = Math.max(key.length(), value.length());
            if (count > minLength) {
                int remainingCount = count - minLength;
                Widget.repeat(kit, remainingCount / 2, ' ');
                kit.print(Widget.center(drawKey ? key : value, minLength));
                Widget.repeat(kit, remainingCount - remainingCount / 2, ' ');
                continue;
            }
            Widget.repeat(kit, count, ' ');
            legendEntries.putIfAbsent(key, value);
        }
        kit.println();
    }

    private void visualizeBar(DrawKit kit, HashMap<String, Integer> tileCount, BiFunction<Integer, Color, Character> barGlyph) {
        kit.print("  ");
        int entryIndex = 0;
        for (Map.Entry<String, Number> entry : this.breakdown.entrySet()) {
            int count = tileCount.get(entry.getKey());
            Color c = this.colors.get(entry.getKey());
            kit.color(c);
            for (int i = 0; i < count; ++i) {
                kit.print(barGlyph.apply(entryIndex, c).charValue());
            }
            kit.color(Color.RESET);
            ++entryIndex;
        }
        kit.print("  ");
        kit.println();
    }
}

