/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.Color;
import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.VisualizationSupport;
import java.io.PrintStream;

public class PrintStreamDrawKit
implements DrawKit {
    private final PrintStream out;
    private Color currentColor;

    public PrintStreamDrawKit(PrintStream out) {
        this.out = out;
        this.currentColor = Color.RESET;
    }

    @Override
    public int width() {
        return 124;
    }

    @Override
    public Color color() {
        return this.currentColor;
    }

    @Override
    public void color(Color c) {
        if (((Boolean)VisualizationSupport.Options.CLIVisualizationMonochrome.getValue()).booleanValue()) {
            return;
        }
        this.currentColor = c;
        this.out.print(c.ansiCode());
    }

    @Override
    public void print(char c) {
        this.out.print(c);
    }

    @Override
    public void print(String s) {
        this.out.print(s);
    }

    @Override
    public void println(String s) {
        this.out.println(s);
    }
}

