/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.Color;
import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;
import java.util.LinkedHashMap;
import java.util.Map;

public class PanelGroupWidget
implements Widget {
    private final String title;
    private final LinkedHashMap<String, Widget> contents;

    public PanelGroupWidget(String title, LinkedHashMap<String, Widget> contents) {
        this.title = title;
        this.contents = contents;
    }

    @Override
    public void visualize(DrawKit kit) {
        InnerDrawKit innerKit = new InnerDrawKit(kit);
        innerKit.printHeader();
        for (Map.Entry<String, Widget> entry : this.contents.entrySet()) {
            innerKit.printSection(entry.getKey());
            Widget widget = entry.getValue();
            widget.visualize(innerKit);
        }
        innerKit.printFooter();
    }

    class InnerDrawKit
    implements DrawKit {
        private final DrawKit outer;
        private final Color panelColor;
        private final Color dividerColor;
        private final Color titleColor;
        private final Color sectionColor;
        private final Color defaultColor;
        private int column;

        InnerDrawKit(DrawKit outer) {
            this.outer = outer;
            this.panelColor = new Color(60, 110, 140);
            this.dividerColor = new Color(70, 70, 70);
            this.titleColor = new Color(100, 180, 255);
            this.sectionColor = new Color(240, 240, 240);
            this.defaultColor = new Color(200, 200, 200);
            this.column = 0;
        }

        @Override
        public int width() {
            return this.outer.width() - 2;
        }

        @Override
        public Color color() {
            return this.outer.color();
        }

        @Override
        public void color(Color c) {
            this.outer.color(c);
            if (c == Color.RESET) {
                this.outer.color(this.defaultColor);
            }
        }

        @Override
        public void print(char c) {
            this.printBorderAtZero();
            if (c == '\n') {
                this.finishLine();
                return;
            }
            if (this.column < this.width()) {
                ++this.column;
            }
            this.outer.print(c);
        }

        @Override
        public void print(String s) {
            this.printBorderAtZero();
            String[] parts = s.split(String.valueOf('\n'));
            boolean first = true;
            for (String part : parts) {
                if (first) {
                    first = false;
                } else {
                    this.finishLine();
                    this.printBorderAtZero();
                }
                this.outer.print(part);
                this.column += part.length();
            }
        }

        @Override
        public void println(String s) {
            this.print(s);
            this.finishLine();
        }

        public void printHeader() {
            this.outer.color(this.panelColor);
            this.printPanelHeading(PanelGroupWidget.this.title, this.titleColor, '\u250c', '\u2510', this.panelColor, '\u2524', '\u251c', this.panelColor);
            this.outer.color(Color.RESET);
        }

        public void printSection(String name) {
            this.printPanelHeading(name, this.sectionColor, '\u251c', '\u2524', this.panelColor, '\u2500', '\u2500', this.dividerColor);
        }

        private void printPanelHeading(String label, Color labelColor, char leftSide, char rightSide, Color sideColor, char labelLeft, char labelRight, Color barColor) {
            int width = this.width();
            if (width < 2) {
                return;
            }
            this.outer.color(sideColor);
            this.outer.print(leftSide);
            this.outer.color(barColor);
            int afterTitle = 0;
            if (width > 4 + label.length()) {
                this.outer.print('\u2500');
                this.outer.print(labelLeft);
                Color previousColor = this.outer.color();
                this.outer.color(labelColor);
                this.outer.color(Color.BOLD);
                this.outer.print(label);
                this.outer.color(Color.RESET);
                this.outer.color(previousColor);
                this.outer.print(labelRight);
                this.outer.print('\u2500');
                afterTitle = 4 + label.length();
            }
            for (int i = afterTitle; i < width; ++i) {
                this.outer.print('\u2500');
            }
            this.outer.color(sideColor);
            this.outer.print(rightSide);
            this.outer.println();
        }

        private void printBorderAtZero() {
            if (this.column == 0) {
                this.outer.color(this.panelColor);
                this.outer.print('\u2502');
                this.color(Color.RESET);
            }
        }

        private void finishLine() {
            int width = this.width();
            while (this.column < width) {
                this.outer.print(' ');
                ++this.column;
            }
            this.outer.color(this.panelColor);
            this.outer.print('\u2502');
            this.outer.color(Color.RESET);
            this.outer.println();
            this.column = 0;
        }

        public void printFooter() {
            int width = this.width();
            if (width < 2) {
                return;
            }
            this.outer.color(this.panelColor);
            this.outer.print('\u2514');
            for (int i = 0; i < width; ++i) {
                this.outer.print('\u2500');
            }
            this.outer.print('\u2518');
            this.outer.println();
            this.outer.color(Color.RESET);
        }
    }
}

