/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.Color;
import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;
import java.util.HashMap;
import java.util.Map;

public class LogHistogramWidget
implements Widget {
    private static final char RIGHT_ARROW = '\u2b9e';
    private static final int MIN_WIDTH = 40;
    private final Map<Number, Number> classes;
    private final String unit;
    private final Color color;
    private final int height;

    public LogHistogramWidget(Map<Number, Number> classes, String unit, Color color, int height) {
        this.classes = classes;
        this.unit = unit;
        this.color = color;
        this.height = height;
        assert (height > 4) : height;
    }

    @Override
    public void visualize(DrawKit kit) {
        int x;
        int y;
        if (kit.width() < 40) {
            kit.println(Widget.trunc("(too narrow console)", kit.width()));
            kit.println();
            return;
        }
        int yLabelWidth = 4;
        int histogramWidth = kit.width() - 4;
        int tickDelta = 4;
        int tickCount = (histogramWidth - 8) / 4;
        long maxCount = 1L;
        long unaccounted = 0L;
        HashMap<Integer, Number> buckets = new HashMap<Integer, Number>();
        for (int i = 0; i <= tickCount; ++i) {
            buckets.put(i, 0);
        }
        for (Map.Entry<Number, Number> entry : this.classes.entrySet()) {
            long sizeClass = entry.getKey().intValue();
            if (sizeClass <= 0L) continue;
            long count = entry.getValue().longValue();
            maxCount = Math.max(count, maxCount);
            int bucket = (int)LogHistogramWidget.exponentUp(sizeClass);
            if (bucket >= tickCount) {
                unaccounted += count;
                continue;
            }
            buckets.put(bucket, ((Number)buckets.get(bucket)).longValue() + count);
        }
        long maxCountRounded = 1L << (int)LogHistogramWidget.exponentUp(maxCount);
        int maxCountRoundedExponent = Long.numberOfTrailingZeros(maxCountRounded);
        int maxHeight = this.height - 3;
        HashMap<Integer, Double> yExponents = new HashMap<Integer, Double>();
        HashMap<Integer, Long> yIntExponents = new HashMap<Integer, Long>();
        HashMap<Integer, Object> yLabels = new HashMap<Integer, Object>();
        yExponents.put(0, 0.0);
        yIntExponents.put(0, 0L);
        yLabels.put(0, "2^0");
        for (y = 1; y <= maxHeight; ++y) {
            long intExponent = maxCountRoundedExponent * y / maxHeight;
            yIntExponents.put(y, intExponent);
            if (intExponent > (Long)yIntExponents.get(y - 1)) {
                yLabels.put(y, "2^" + intExponent);
            } else {
                yLabels.put(y, "");
            }
            yExponents.put(y, (double)maxCountRoundedExponent * (double)y / (double)maxHeight);
        }
        for (y = maxHeight; y >= 0; --y) {
            int x2;
            long countAtY = (long)Math.pow(2.0, (Double)yExponents.get(y));
            kit.print(Widget.pad((String)yLabels.get(y), 4, true));
            kit.print('\u251c');
            kit.color(this.color);
            for (x2 = 0; x2 < 2; ++x2) {
                kit.print(' ');
            }
            for (x2 = 4; x2 < histogramWidth - 4; x2 += 4) {
                int i;
                int bucket = (x2 - 4) / 4;
                long count = ((Number)buckets.get(bucket)).longValue();
                if (count >= countAtY) {
                    kit.print("\u2590\u2588\u258c");
                    for (i = 0; i < 1; ++i) {
                        kit.print(' ');
                    }
                    continue;
                }
                for (i = 0; i < 4; ++i) {
                    kit.print(' ');
                }
            }
            kit.color(Color.RESET);
            kit.println();
        }
        LogHistogramWidget.yLabelSpace(kit, 4);
        kit.print('\u2514');
        for (x = 1; x < histogramWidth - 4; ++x) {
            kit.print(x % 4 == 0 ? (char)'\u2534' : '\u2500');
        }
        for (x = 0; x < 3; ++x) {
            kit.print('\u2500');
        }
        kit.print('\u2b9e');
        kit.println();
        LogHistogramWidget.yLabelSpace(kit, 4);
        for (x = 0; x < 3; ++x) {
            kit.print(' ');
        }
        for (x = 4; x < histogramWidth - 4; x += 4) {
            kit.print('^');
            kit.print(Widget.pad(Widget.hardTrunc(String.valueOf((x - 4) / 4), 2), 2, false));
            kit.print(' ');
        }
        kit.print(Widget.hardTrunc(" " + this.unit, 4));
        kit.println();
        if (unaccounted > 0L) {
            System.out.println("Unaccounted (> 2^" + (tickCount - 1) + " " + this.unit + "): " + unaccounted);
        }
    }

    private static long exponentUp(long maxCount) {
        return 64 - Long.numberOfLeadingZeros(maxCount - 1L);
    }

    private static void yLabelSpace(DrawKit kit, int yLabelWidth) {
        for (int x = 0; x < yLabelWidth; ++x) {
            kit.print(' ');
        }
    }
}

