/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;

public class HeaderWidget
implements Widget {
    private static final int MIN_WIDTH = 8;
    private final String title;

    public HeaderWidget(String title) {
        this.title = title;
    }

    @Override
    public void visualize(DrawKit kit) {
        int i;
        if (kit.width() < 8) {
            return;
        }
        int titleWidth = Math.min(kit.width() - 4, this.title.length());
        kit.println();
        kit.print("\u256d\u2500");
        for (i = 0; i < titleWidth; ++i) {
            kit.print("\u2500");
        }
        kit.print("\u2500\u256e");
        kit.println();
        kit.println("\u2502 " + this.title.substring(0, titleWidth) + " \u2502");
        kit.print("\u2570\u2500");
        for (i = 0; i < titleWidth; ++i) {
            kit.print("\u2500");
        }
        kit.print("\u2500\u256f");
        kit.println();
        kit.println();
    }
}

