/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

public class Color {
    public static final Color RESET = new Color("\u001b[0m");
    public static final Color BLACK = new Color("\u001b[30m");
    public static final Color RED = new Color("\u001b[31m");
    public static final Color GREEN = new Color("\u001b[32m");
    public static final Color YELLOW = new Color("\u001b[33m");
    public static final Color BLUE = new Color("\u001b[34m");
    public static final Color PURPLE = new Color("\u001b[35m");
    public static final Color CYAN = new Color("\u001b[36m");
    public static final Color WHITE = new Color("\u001b[37m");
    public static final Color BLACK_BRIGHT = new Color("\u001b[0;90m");
    public static final Color RED_BRIGHT = new Color("\u001b[0;91m");
    public static final Color GREEN_BRIGHT = new Color("\u001b[0;92m");
    public static final Color YELLOW_BRIGHT = new Color("\u001b[0;93m");
    public static final Color BLUE_BRIGHT = new Color("\u001b[0;94m");
    public static final Color PURPLE_BRIGHT = new Color("\u001b[0;95m");
    public static final Color CYAN_BRIGHT = new Color("\u001b[0;96m");
    public static final Color WHITE_BRIGHT = new Color("\u001b[0;97m");
    public static final Color BOLD = new Color("\u001b[1m");
    private static final String RGB_PREFIX = "\u001b[38;2;";
    private static final String RGB_POSTFIX = "m";
    private final String ansiCode;

    private Color(String ansiCode) {
        this.ansiCode = ansiCode;
    }

    public Color(int r, int g, int b) {
        this(RGB_PREFIX + Color.clamp(r) + ";" + Color.clamp(g) + ";" + Color.clamp(b) + RGB_POSTFIX);
    }

    public String ansiCode() {
        return this.ansiCode;
    }

    private static int clamp(int x) {
        if (x < 0) {
            return 0;
        }
        if (x > 255) {
            return 255;
        }
        return x;
    }
}

