/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.visualization.BarPlotWidget;
import com.oracle.svm.hosted.webimage.logging.visualization.Color;
import com.oracle.svm.hosted.webimage.logging.visualization.LogHistogramWidget;
import com.oracle.svm.hosted.webimage.logging.visualization.PanelGroupWidget;
import com.oracle.svm.hosted.webimage.logging.visualization.PrintStreamDrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.StackedBarWidget;
import com.oracle.svm.hosted.webimage.logging.visualization.SummaryWidget;
import com.oracle.svm.hosted.webimage.logging.visualization.VisualizationSupport;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.metrics.ImageMetricsCollector;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.debug.MetricKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicSet;

public class CLIVisualizationSupport
extends VisualizationSupport {
    private static final HashMap<String, Color> SIZE_COLORS = new HashMap();
    private static final HashMap<String, Color> TYPE_COLORS = new HashMap();
    private static final HashMap<String, Color> METHOD_COLORS = new HashMap();

    public static Map<String, Number> toMap() {
        TimerCollection timerCollection = TimerCollection.singleton();
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        map.put(TimerCollection.Registry.SETUP.name, timerCollection.get(TimerCollection.Registry.SETUP).getTotalTime());
        map.put(TimerCollection.Registry.ANALYSIS.name, timerCollection.get(TimerCollection.Registry.ANALYSIS).getTotalTime());
        map.put(TimerCollection.Registry.UNIVERSE.name, timerCollection.get(TimerCollection.Registry.UNIVERSE).getTotalTime());
        map.put(TimerCollection.Registry.COMPILE_TOTAL.name, timerCollection.get(TimerCollection.Registry.COMPILE_TOTAL).getTotalTime());
        map.put("emit", timerCollection.get("emit").getTotalTime());
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            map.put("closure", timerCollection.get("closure").getTotalTime());
        }
        return map;
    }

    @Override
    public void visualize(PrintStream printStream) {
        PrintStreamDrawKit kit = new PrintStreamDrawKit(printStream);
        WebImageOptions.CompilerBackend backend = WebImageOptions.getBackend();
        kit.println();
        LinkedHashMap<String, Widget> contents = new LinkedHashMap<String, Widget>();
        CLIVisualizationSupport.visualizeInfo(contents);
        CLIVisualizationSupport.visualizeStepTiming(contents);
        CLIVisualizationSupport.visualizeTypeCounts(contents);
        CLIVisualizationSupport.visualizeMethodCounts(contents);
        if (backend == WebImageOptions.CompilerBackend.JS) {
            CLIVisualizationSupport.visualizeObjectSizes(contents);
        }
        EconomicSet breakdownKeys = EconomicSet.create();
        breakdownKeys.addAll(Arrays.asList(ImageMetricsCollector.SAVED_SIZE_BREAKDOWN_KEYS));
        breakdownKeys.remove((Object)ImageBreakdownMetricKeys.TOTAL_METHOD_SIZE);
        if (backend == WebImageOptions.CompilerBackend.WASM) {
            breakdownKeys.clear();
            breakdownKeys.add((Object)ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE);
            breakdownKeys.add((Object)ImageBreakdownMetricKeys.EXTRA_DEFINITIONS_SIZE);
            breakdownKeys.add((Object)ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE);
        }
        MetricKey[] breakdownKeysArray = (MetricKey[])breakdownKeys.toArray((Object[])new MetricKey[breakdownKeys.size()]);
        CLIVisualizationSupport.visualizeBreakdown(LoggerContext.getQualifiedScopeName("Code-Generation", "Pre-Closure"), "pre-closure size breakdown", contents, breakdownKeysArray);
        if (backend == WebImageOptions.CompilerBackend.JS && ((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            CLIVisualizationSupport.visualizeBreakdown(LoggerContext.getQualifiedScopeName("Code-Generation", "Closure-Compiler"), "post-closure size breakdown", contents, breakdownKeysArray);
        }
        PanelGroupWidget panel = new PanelGroupWidget("Web Image Build Statistics", contents);
        panel.visualize(kit);
        kit.println();
    }

    private static void visualizeInfo(LinkedHashMap<String, Widget> contents) {
        SummaryWidget summary = new SummaryWidget(CLIVisualizationSupport.createInfo());
        contents.put("summary", summary);
    }

    private static LinkedHashMap<String, String> createInfo() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        OptionValues options = HostedOptionValues.singleton();
        info.put("Image name", (String)SubstrateOptions.Name.getValue(options));
        info.put("Target VM", WebImageOptions.getTargetVM());
        info.put("Backend", WebImageOptions.getBackend().name());
        info.put("Host JDK", System.getProperty("java.version"));
        StringBuilder optionSummary = new StringBuilder();
        optionSummary.append("<naming=" + ((WebImageNamingConvention.NamingMode)((Object)WebImageOptions.NamingConvention.getValue(options))).toString().toLowerCase(Locale.ROOT) + "> ");
        if (((Boolean)WebImageOptions.UsePEA.getValue(options)).booleanValue()) {
            optionSummary.append("<pea> ");
        }
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            optionSummary.append("<closure> ");
        }
        if (((Boolean)WebImageOptions.AutoRunVM.getValue(options)).booleanValue()) {
            optionSummary.append("<autorun> ");
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            optionSummary.append("<little-endian> ");
        } else {
            optionSummary.append("<big-endian> ");
        }
        info.put("Settings summary", optionSummary.toString());
        return info;
    }

    private static void visualizeStepTiming(LinkedHashMap<String, Widget> contents) {
        BarPlotWidget buildTimes = new BarPlotWidget(CLIVisualizationSupport.toMap(), Optional.of(TimerCollection.singleton().get("total-WebImage").getTotalTime()), "ms", label -> Color.BLUE_BRIGHT);
        contents.put("build timing", buildTimes);
    }

    private static void visualizeObjectSizes(LinkedHashMap<String, Widget> contents) {
        Map<String, Number> savedCounters = LoggerContext.currentContext().getSavedCounters(LoggerContext.getQualifiedScopeName("Code-Generation"), ImageBreakdownMetricKeys.CONSTANT_SIZE_CLASSES.toArray(new MetricKey[0]));
        HashMap<Number, Number> sizeClasses = new HashMap<Number, Number>();
        for (MetricKey sizeClassKey : ImageBreakdownMetricKeys.CONSTANT_SIZE_CLASSES) {
            String name = sizeClassKey.getName();
            int sizeClass = Integer.parseInt(name.substring(name.lastIndexOf("-") + 1));
            long count = savedCounters.get(name).longValue();
            sizeClasses.put(1 << sizeClass, count);
        }
        LogHistogramWidget objectSizeHistogram = new LogHistogramWidget(sizeClasses, "B", Color.BLUE_BRIGHT, 12);
        contents.put("pre-closure object-size", objectSizeHistogram);
    }

    private static void visualizeTypeCounts(LinkedHashMap<String, Widget> contents) {
        LinkedHashMap<String, Number> counters = new LinkedHashMap<String, Number>();
        counters.putAll(LoggerContext.currentContext().getSavedCounters("Universe-Build", UniverseMetricKeys.ANALYSIS_TYPES, UniverseMetricKeys.HOSTED_TYPES));
        counters.putAll(LoggerContext.currentContext().getSavedCounters("Compile-Queue", UniverseMetricKeys.COMPILED_TYPES));
        counters.putAll(LoggerContext.currentContext().getSavedCounters("Code-Generation", UniverseMetricKeys.EMITTED_TYPES));
        BarPlotWidget typeCounts = new BarPlotWidget(counters, Optional.empty(), "", TYPE_COLORS::get);
        contents.put("reachable types", typeCounts);
    }

    private static void visualizeMethodCounts(LinkedHashMap<String, Widget> contents) {
        LinkedHashMap<String, Number> counters = new LinkedHashMap<String, Number>();
        counters.putAll(LoggerContext.currentContext().getSavedCounters("Universe-Build", UniverseMetricKeys.ANALYSIS_METHODS, UniverseMetricKeys.HOSTED_METHODS));
        counters.putAll(LoggerContext.currentContext().getSavedCounters("Compile-Queue", UniverseMetricKeys.COMPILED_METHODS));
        counters.putAll(LoggerContext.currentContext().getSavedCounters("Code-Generation", UniverseMetricKeys.EMITTED_METHODS));
        BarPlotWidget typeCounts = new BarPlotWidget(counters, Optional.empty(), "", METHOD_COLORS::get);
        contents.put("reachable methods", typeCounts);
    }

    private static void visualizeBreakdown(String scopeName, String title, LinkedHashMap<String, Widget> contents, MetricKey[] breakdownKeys) {
        LoggerContext context = LoggerContext.currentContext();
        LinkedHashMap<String, Number> savedCounters = new LinkedHashMap<String, Number>(context.getSavedCounters(scopeName, breakdownKeys));
        Number totalSize = (Number)savedCounters.get(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE.getName());
        savedCounters.remove(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE.getName());
        StackedBarWidget sizeBreakdown = new StackedBarWidget(savedCounters, totalSize, "kB", 1000, SIZE_COLORS);
        contents.put(title, sizeBreakdown);
    }

    static {
        SIZE_COLORS.put(ImageBreakdownMetricKeys.INITIAL_DEFINITIONS_SIZE.getName(), Color.WHITE);
        SIZE_COLORS.put(ImageBreakdownMetricKeys.EXTRA_DEFINITIONS_SIZE.getName(), Color.BLACK_BRIGHT);
        SIZE_COLORS.put(ImageBreakdownMetricKeys.STATIC_FIELDS_SIZE.getName(), Color.GREEN);
        SIZE_COLORS.put(ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE.getName(), Color.GREEN_BRIGHT);
        SIZE_COLORS.put(ImageBreakdownMetricKeys.RECONSTRUCTED_SIZE.getName(), Color.BLUE);
        SIZE_COLORS.put(ImageBreakdownMetricKeys.NO_CF_SIZE.getName(), Color.BLUE_BRIGHT);
        SIZE_COLORS.put(ImageBreakdownMetricKeys.CONSTANTS_SIZE.getName(), Color.YELLOW_BRIGHT);
        TYPE_COLORS.put(UniverseMetricKeys.ANALYSIS_TYPES.getName(), new Color(250, 160, 100));
        TYPE_COLORS.put(UniverseMetricKeys.HOSTED_TYPES.getName(), Color.GREEN_BRIGHT);
        TYPE_COLORS.put(UniverseMetricKeys.COMPILED_TYPES.getName(), Color.BLUE);
        TYPE_COLORS.put(UniverseMetricKeys.EMITTED_TYPES.getName(), Color.YELLOW_BRIGHT);
        METHOD_COLORS.put(UniverseMetricKeys.ANALYSIS_METHODS.getName(), new Color(250, 160, 100));
        METHOD_COLORS.put(UniverseMetricKeys.HOSTED_METHODS.getName(), Color.GREEN_BRIGHT);
        METHOD_COLORS.put(UniverseMetricKeys.COMPILED_METHODS.getName(), Color.BLUE);
        METHOD_COLORS.put(UniverseMetricKeys.EMITTED_METHODS.getName(), Color.YELLOW_BRIGHT);
    }
}

