/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging.visualization;

import com.oracle.svm.hosted.webimage.logging.visualization.Color;
import com.oracle.svm.hosted.webimage.logging.visualization.DrawKit;
import com.oracle.svm.hosted.webimage.logging.visualization.Widget;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class BarPlotWidget
implements Widget {
    private static final int MIN_WIDTH = 40;
    private final Map<String, Number> categories;
    private final Optional<Number> totalValue;
    private final String unit;
    private final Function<String, Color> coloring;

    public BarPlotWidget(Map<String, Number> categories, Optional<Number> totalValue, String unit, Function<String, Color> coloring) {
        this.coloring = coloring;
        this.categories = categories;
        this.totalValue = totalValue;
        this.unit = unit;
    }

    @Override
    public void visualize(DrawKit kit) {
        if (kit.width() < 40) {
            kit.println(Widget.trunc("(too narrow console)", kit.width()));
            kit.println();
            return;
        }
        int maxNumberWidth = 0;
        double valueSum = 0.0;
        double maxValue = 0.0;
        for (Number number : this.categories.values()) {
            valueSum += number.doubleValue();
            maxValue = Math.max(maxValue, number.doubleValue());
            String s = this.asString(number.doubleValue());
            maxNumberWidth = Math.max(maxNumberWidth, s.length());
        }
        int maxLabelWidth = 0;
        for (String s : this.categories.keySet()) {
            maxLabelWidth = Math.max(maxLabelWidth, s.length());
        }
        maxLabelWidth = Math.min(maxLabelWidth, kit.width() / 3);
        maxNumberWidth += 1 + this.unit.length();
        maxNumberWidth = Math.min(maxNumberWidth, kit.width() / 5);
        int n = kit.width() - maxLabelWidth - maxNumberWidth - 4;
        for (Map.Entry<String, Number> entry : this.categories.entrySet()) {
            String label = entry.getKey();
            double value = entry.getValue().doubleValue();
            kit.print(Widget.pad(Widget.trunc(label, maxLabelWidth), maxLabelWidth, true));
            kit.print(" \u251c ");
            int barWidth = (int)(value / maxValue * (double)n);
            kit.color(this.coloring.apply(label));
            if (barWidth > 0) {
                for (int i = 0; i < barWidth; ++i) {
                    kit.print('\u2585');
                }
            } else {
                kit.print('\u2596');
            }
            kit.color(Color.RESET);
            kit.print(' ');
            kit.print(Widget.pad(Widget.trunc(this.asString(value), maxNumberWidth), maxNumberWidth, false));
            kit.println();
        }
        if (this.totalValue.isPresent()) {
            kit.println("Total:  " + Widget.trunc(this.asString(this.totalValue.get().doubleValue()), maxNumberWidth));
            kit.println("Unacc.: " + Widget.trunc(this.asString(this.totalValue.get().doubleValue() - valueSum), maxNumberWidth));
        }
    }

    private String asString(double value) {
        return String.format("%.2f %s", value, this.unit);
    }
}

