/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging;

import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerPrinter;
import com.oracle.svm.hosted.webimage.logging.LoggerScopeImpl;

public class ReadableTextLoggerPrinter
implements LoggerPrinter {
    @Override
    public void print(LoggerScopeImpl loggerScope) {
        StringBuilder sb = new StringBuilder();
        Iterable metrics = loggerScope.getMetrics().getValues();
        int maxNameWidth = 0;
        for (LoggableMetric metric : metrics) {
            maxNameWidth = Math.max(maxNameWidth, metric.getName().length());
        }
        String format = "%-" + maxNameWidth + "s =%15s";
        for (LoggableMetric metric : metrics) {
            sb.append(String.format(format, metric.getName(), metric.get()));
            sb.append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        loggerScope.getDebugContext().log("%s", (Object)sb);
    }
}

