/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.logging.LoggableCounter;
import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.MetricKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

class LoggerScopeImpl
implements LoggerScope {
    private final String name;
    private final String qualifiedName;
    private final LoggerContext context;
    private final LoggerScopeImpl parent;
    private final DebugContext debugContext;
    private final LoggerScope.OnCloseHandler onCloseHandler;
    private final DebugContext.Scope scope;
    private boolean closed;
    private final EconomicMap<MetricKey, LoggableMetric> metrics;

    LoggerScopeImpl(String name, LoggerContext context, LoggerScope.OnCloseHandler onCloseHandler, LoggerScopeImpl parent) {
        this.name = name;
        this.qualifiedName = parent == null ? name : parent.getQualifiedName() + "." + name;
        this.parent = parent;
        this.onCloseHandler = onCloseHandler;
        this.debugContext = new DebugContext.Builder(context.getOptions()).logStream(context.getStream()).description(null).build();
        this.context = context;
        this.metrics = EconomicMap.create();
        this.scope = this.debugContext.scope((Object)this.qualifiedName);
        this.closed = false;
    }

    @Override
    public LoggerScope scope(String scopeName) {
        return this.context.scope(scopeName);
    }

    @Override
    public LoggerScope scope(String scopeName, LoggerScope.OnCloseHandler handler) {
        return this.context.scope(scopeName, handler);
    }

    @Override
    public LoggerScope scope(HostedMethod method) {
        return this.context.scope(method);
    }

    @Override
    public LoggerScope scope(HostedMethod method, LoggerScope.OnCloseHandler handler) {
        return this.context.scope(method, handler);
    }

    @Override
    public LoggableCounter counter(MetricKey key) {
        return this.lazyPutIfAbsent(key, () -> new LoggableCounter(this, DebugContext.counter((CharSequence)key.getName())));
    }

    private <T extends LoggableMetric> T lazyPutIfAbsent(MetricKey key, Supplier<T> provider) {
        assert (provider != null);
        LoggableMetric metric = (LoggableMetric)this.metrics.get((Object)key);
        if (metric == null) {
            metric = (LoggableMetric)provider.get();
            this.metrics.put((Object)key, (Object)metric);
        }
        return (T)metric;
    }

    @Override
    public void close() {
        this.printMetrics();
        if (this.scope != null) {
            this.scope.close();
        }
        this.onCloseHandler.accept(this, this.metrics);
        this.context.setCurrentScope(this.parent);
        this.debugContext.close();
        this.closed = true;
    }

    @Override
    public Map<String, Number> countersMap(MetricKey ... keys) {
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        for (MetricKey key : keys) {
            map.put(key.getName(), this.counter(key).get());
        }
        return map;
    }

    @Override
    public UnmodifiableEconomicMap<MetricKey, Number> getExtractedMetrics() {
        EconomicMap map = EconomicMap.create((int)this.metrics.size());
        for (MetricKey key : this.metrics.getKeys()) {
            map.put((Object)key, (Object)this.counter(key).get());
        }
        return map;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public LoggerScope parent() {
        return this.parent;
    }

    DebugContext getDebugContext() {
        return this.debugContext;
    }

    boolean isClosed() {
        return this.closed;
    }

    UnmodifiableEconomicMap<MetricKey, LoggableMetric> getMetrics() {
        return this.metrics;
    }

    private void printMetrics() {
        this.debugContext.printMetrics(new DebugContext.Description((Object)this.qualifiedName, ""));
        if (this.debugContext.isLogEnabled()) {
            this.context.getLoggerPrinter().print(this);
        }
    }
}

