/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.logging.BenchmarkLoggerPrinter;
import com.oracle.svm.hosted.webimage.logging.LoggableCounter;
import com.oracle.svm.hosted.webimage.logging.LoggerPrinter;
import com.oracle.svm.hosted.webimage.logging.LoggerScope;
import com.oracle.svm.hosted.webimage.logging.LoggerScopeImpl;
import com.oracle.svm.hosted.webimage.logging.ReadableTextLoggerPrinter;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.debug.MetricKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;

public final class LoggerContext
implements AutoCloseable {
    public static final String QUALIFIED_NAME_SEPARATOR = ".";
    public static final LoggerScope.OnCloseHandler EMPTY_ON_CLOSE_HANDLER = (parentScope, metrics) -> {};
    private static final ThreadLocal<LoggerContext> currentLoggerContext = new ThreadLocal();
    private final Map<String, Map<String, Number>> savedCounters = new HashMap<String, Map<String, Number>>();
    private final OptionValues debugContextOptions;
    private final PrintStream stream;
    private final LoggerPrinter loggerPrinter;
    private final LoggerScope.OnCloseHandler defaultOnCloseHandler;
    private LoggerScopeImpl currentScope;
    private LoggerContext parent;

    public static PrintStream getDefaultStream() {
        return System.out;
    }

    private LoggerContext(OptionValues options, PrintStream stream, LoggerScope.OnCloseHandler onCloseHandler, boolean deleteMetricFile) {
        this.debugContextOptions = LoggerContext.convertOptionValues(options);
        this.stream = stream;
        this.defaultOnCloseHandler = onCloseHandler;
        this.loggerPrinter = LoggerContext.getLoggerPrinter(options);
        this.parent = currentLoggerContext.get();
        currentLoggerContext.set(this);
        if (deleteMetricFile) {
            this.deleteMetricFile();
        }
    }

    private static OptionValues convertOptionValues(OptionValues options) {
        EconomicMap optionMap = OptionValues.newOptionMap();
        optionMap.put((Object)DebugOptions.MetricsFile, WebImageOptions.LoggerOptions.LoggingFile.getValue(options));
        optionMap.put((Object)DebugOptions.Log, WebImageOptions.LoggerOptions.LogFilter.getValue(options));
        optionMap.put((Object)DebugOptions.Count, (Object)"");
        return new OptionValues((UnmodifiableEconomicMap)optionMap);
    }

    private static LoggerPrinter getLoggerPrinter(OptionValues options) {
        switch ((WebImageOptions.LoggerOptions.LoggingFormat)((Object)WebImageOptions.LoggerOptions.LoggingStyle.getValue(options))) {
            case ReadableText: {
                return new ReadableTextLoggerPrinter();
            }
            case BenchmarkText: {
                return new BenchmarkLoggerPrinter((String)WebImageOptions.BenchmarkName.getValue(options));
            }
        }
        assert (false) : "Should not reach here";
        return null;
    }

    private void deleteMetricFile() {
        File file;
        String metricFileName = this.getMetricFileName();
        if (metricFileName != null && (file = new File(metricFileName)).exists()) {
            file.delete();
        }
    }

    public void saveCounters(LoggerScope scope, MetricKey ... keys) {
        this.savedCounters.put(scope.getQualifiedName(), scope.countersMap(keys));
    }

    public Map<String, Number> getSavedCounters(String qualifiedName, MetricKey ... keys) {
        Map<String, Number> saved = this.savedCounters.get(qualifiedName);
        LinkedHashMap<String, Number> subset = new LinkedHashMap<String, Number>();
        for (MetricKey key : keys) {
            subset.put(key.getName(), saved.get(key.getName()));
        }
        return subset;
    }

    public LoggerScope scope(String name, LoggerScope.OnCloseHandler onCloseHandler) {
        return this.enterScope(name, onCloseHandler);
    }

    public LoggerScope scope(String name) {
        return this.enterScope(name, this.defaultOnCloseHandler);
    }

    public LoggerScope scope(HostedMethod method, LoggerScope.OnCloseHandler onCloseHandler) {
        return this.enterScope(method.getQualifiedName(), onCloseHandler);
    }

    public LoggerScope scope(HostedMethod method) {
        return this.enterScope(method.getQualifiedName(), this.defaultOnCloseHandler);
    }

    LoggerScopeImpl enterScope(String name, LoggerScope.OnCloseHandler onCloseHandler) {
        LoggerScopeImpl scope = new LoggerScopeImpl(name, this, onCloseHandler, this.currentScope);
        this.setCurrentScope(scope);
        return scope;
    }

    public LoggerScope currentScope() {
        return this.currentScope;
    }

    void setCurrentScope(LoggerScopeImpl scope) {
        this.currentScope = scope;
    }

    @Override
    public void close() {
        assert (currentLoggerContext.get() == this) : currentLoggerContext.get();
        this.currentScope = null;
        currentLoggerContext.set(this.parent);
        this.parent = null;
    }

    OptionValues getOptions() {
        return this.debugContextOptions;
    }

    String getMetricFileName() {
        return (String)DebugOptions.MetricsFile.getValue(this.debugContextOptions);
    }

    PrintStream getStream() {
        return this.stream;
    }

    LoggerPrinter getLoggerPrinter() {
        return this.loggerPrinter;
    }

    public static LoggerContext currentContext() {
        return currentLoggerContext.get();
    }

    public static LoggableCounter counter(MetricKey key) {
        return currentLoggerContext.get().currentScope().counter(key);
    }

    public void mergeSavedCounters(UnmodifiableEconomicMap<MetricKey, Number> metrics) {
        UnmodifiableMapCursor cursor = metrics.getEntries();
        while (cursor.advance()) {
            this.currentScope.counter((MetricKey)cursor.getKey()).add(((Number)cursor.getValue()).longValue());
        }
    }

    public static String getQualifiedScopeName(String ... scopes) {
        assert (scopes.length >= 1) : Arrays.toString(scopes);
        StringBuilder sb = new StringBuilder();
        sb.append(scopes[0]);
        for (int i = 1; i < scopes.length; ++i) {
            sb.append(QUALIFIED_NAME_SEPARATOR);
            sb.append(scopes[i]);
        }
        return sb.toString();
    }

    public static class Builder {
        private final OptionValues options;
        private PrintStream logStream;
        private LoggerScope.OnCloseHandler defaultOnCloseHandler;
        private boolean deleteMetricFile;

        public Builder(OptionValues options) {
            this.options = options;
            this.logStream = LoggerContext.getDefaultStream();
            this.defaultOnCloseHandler = EMPTY_ON_CLOSE_HANDLER;
            this.deleteMetricFile = true;
        }

        public Builder stream(PrintStream stream) {
            this.logStream = stream;
            return this;
        }

        public Builder onCloseHandler(LoggerScope.OnCloseHandler onCloseHandler) {
            this.defaultOnCloseHandler = onCloseHandler;
            return this;
        }

        public Builder deleteMetricFile(boolean flag) {
            this.deleteMetricFile = flag;
            return this;
        }

        public LoggerContext build() {
            return new LoggerContext(this.options, this.logStream, this.defaultOnCloseHandler, this.deleteMetricFile);
        }
    }
}

