/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging;

import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerScopeImpl;
import jdk.graal.compiler.debug.CounterKey;

public class LoggableCounter
implements LoggableMetric {
    private final CounterKey counterKey;
    private final LoggerScopeImpl loggerScope;

    LoggableCounter(LoggerScopeImpl loggerScope, CounterKey counterKey) {
        this.counterKey = counterKey;
        this.loggerScope = loggerScope;
    }

    @Override
    public String getName() {
        return this.counterKey.getName();
    }

    @Override
    public long get() {
        return this.counterKey.getCurrentValue(this.loggerScope.getDebugContext());
    }

    public void add(long val) {
        assert (!this.loggerScope.isClosed()) : "Changing metric value is possible while its scope is open.";
        this.counterKey.add(this.loggerScope.getDebugContext(), val);
    }

    public void increment() {
        this.add(1L);
    }
}

