/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.logging;

import com.oracle.svm.hosted.webimage.logging.LoggableMetric;
import com.oracle.svm.hosted.webimage.logging.LoggerPrinter;
import com.oracle.svm.hosted.webimage.logging.LoggerScopeImpl;

public class BenchmarkLoggerPrinter
implements LoggerPrinter {
    private final String benchmarkName;

    public BenchmarkLoggerPrinter(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    @Override
    public void print(LoggerScopeImpl loggerScope) {
        StringBuilder sb = new StringBuilder();
        Iterable metrics = loggerScope.getMetrics().getValues();
        for (LoggableMetric metric : metrics) {
            sb.append(String.format("===== WEB IMAGE COMPILATION %s [%s] %s = %d ====", this.benchmarkName, loggerScope.getQualifiedName(), metric.getName(), metric.get()));
            sb.append(System.lineSeparator());
        }
        loggerScope.getDebugContext().log("%s", (Object)sb);
    }
}

