/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.nodes.LoadMethodByIndexNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.hosted.webimage.WebImageLoweringProvider;
import com.oracle.svm.hosted.webimage.snippets.WebImageIdentityHashCodeSnippets;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.ClassIsArrayNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.memory.ExtendableMemoryAccess;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.replacements.nodes.IdentityHashCodeNode;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;

public class WebImageJSLoweringProvider
extends WebImageLoweringProvider {
    public WebImageJSLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
    }

    protected IdentityHashCodeSnippets.Templates createIdentityHashCodeSnippets(OptionValues options, Providers providers) {
        return WebImageIdentityHashCodeSnippets.createTemplates(options, providers);
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        if (n instanceof EnsureClassInitializedNode || n instanceof ValidateNewInstanceClassNode || n instanceof LoadMethodByIndexNode) {
            NodeLoweringProvider nodeLoweringProvider = (NodeLoweringProvider)this.getLowerings().get(n.getClass());
            if (nodeLoweringProvider == null) {
                throw GraalError.unimplemented((String)("No LoweringProvider found for " + String.valueOf(n.getClass())));
            }
            nodeLoweringProvider.lower(n, tool);
        } else {
            super.lower(n, tool);
        }
    }

    @Override
    public boolean shouldLower(Node n) {
        return n instanceof ClassIsArrayNode || n instanceof IdentityHashCodeNode;
    }

    public Integer smallestCompareWidth() {
        return 32;
    }

    public boolean supportsBulkZeroingOfEden() {
        return false;
    }

    public boolean writesStronglyOrdered() {
        return true;
    }

    public boolean divisionOverflowIsJVMSCompliant() {
        return false;
    }

    public boolean narrowsUseCastValue() {
        return false;
    }

    public boolean supportsFoldingExtendIntoAccess(ExtendableMemoryAccess access, MemoryExtendKind extendKind) {
        return false;
    }
}

