/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.webimage.js.JSObjectAccessMethod;
import com.oracle.svm.hosted.webimage.js.JSStubMethod;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.webimage.api.JS;

public class JSSubstitutionProcessor
extends SubstitutionProcessor {
    private final Map<ResolvedJavaMethod, CustomSubstitutionMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, CustomSubstitutionMethod>();

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ResolvedJavaMethod wrapper = method;
        if (JSSubstitutionProcessor.isJSStubMethod(method)) {
            wrapper = (ResolvedJavaMethod)this.callWrappers.computeIfAbsent(method, JSStubMethod::new);
        }
        return wrapper;
    }

    private static boolean isJSStubMethod(ResolvedJavaMethod method) {
        assert (!(method instanceof AnalysisMethod)) : method;
        return method instanceof JSObjectAccessMethod || AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, JS.class);
    }
}

