/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.js.JSObjectAccessMethod;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.phases.WebImageHostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.annotation.JSRawCall;
import com.oracle.svm.webimage.functionintrinsics.JSConversion;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.webimage.api.JS;

public class JSStubMethod
extends CustomSubstitutionMethod {
    private static final double HIGH_INSTANCEOF_PROBABILITY = 0.9999;

    public JSStubMethod(ResolvedJavaMethod original) {
        super(original);
    }

    public boolean canBeInlined() {
        return false;
    }

    public boolean shouldBeInlined() {
        return false;
    }

    public boolean hasNeverInlineDirective() {
        return true;
    }

    private static Stamp returnStamp(ResolvedSignature<AnalysisType> sig) {
        JavaKind returnKind = sig.getReturnKind();
        if (returnKind == JavaKind.Object) {
            return StampFactory.object((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)sig.getReturnType()));
        }
        return StampFactory.forKind((JavaKind)returnKind);
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JSBody.JSCode jsCode;
        boolean coercion;
        boolean rawCall;
        ResolvedJavaMethod resolvedJavaMethod = this.getOriginal();
        if (resolvedJavaMethod instanceof JSObjectAccessMethod) {
            JSObjectAccessMethod jsObjectAccessMethod = (JSObjectAccessMethod)resolvedJavaMethod;
            rawCall = false;
            coercion = jsObjectAccessMethod.isLoad();
            jsCode = jsObjectAccessMethod.getJSCode();
        } else {
            rawCall = AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, JSRawCall.class);
            coercion = AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, JS.Coerce.class);
            JS js = Objects.requireNonNull((JS)AnnotationAccess.getAnnotation((AnnotatedElement)method, JS.class));
            jsCode = new JSBody.JSCode(js, (ResolvedJavaMethod)method);
        }
        return JSStubMethod.buildGraph(debug, method, providers, purpose, jsCode, coercion, rawCall);
    }

    private static StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose, JSBody.JSCode jsCode, boolean coercion, boolean rawCall) {
        if (rawCall && coercion) {
            throw JVMCIError.shouldNotReachHere((String)("Cannot use JS.Coerce and JSRawCall annotation simultaneously: " + method.format("%H.%n")));
        }
        WebImageHostedGraphKit kit = new WebImageHostedGraphKit(debug, providers, (ResolvedJavaMethod)method, purpose);
        FrameStateBuilder state = kit.getFrameState();
        ValueNode[] arguments = kit.getInitialArguments().toArray(ValueNode.EMPTY_ARRAY);
        AnalysisType returnType = (AnalysisType)method.getSignature().getReturnType();
        List paramTypes = method.toParameterList();
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = JSStubMethod.convertArgument(kit, arguments[i], (AnalysisType)paramTypes.get(i), rawCall, coercion);
            state.clearLocals();
            state.clearStack();
        }
        if (method.isStatic()) {
            ValueNode[] fullArguments = new ValueNode[arguments.length + 1];
            fullArguments[0] = kit.createConstant((Constant)JavaConstant.NULL_POINTER, JavaKind.Object);
            System.arraycopy(arguments, 0, fullArguments, 1, arguments.length);
            arguments = fullArguments;
        }
        int bci = kit.bci();
        Stamp jsBodyStamp = rawCall ? JSStubMethod.returnStamp((ResolvedSignature<AnalysisType>)method.getSignature()) : StampFactory.object();
        AnalysisMethod exceptionHandler = WebImageOptions.getBackend() == WebImageOptions.CompilerBackend.WASMGC ? null : kit.getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupMethod(JSConversion.class, (String)"handleJSError", (Class[])new Class[]{Object.class}));
        ValueNode returnValue = kit.createJSBody(jsCode, (ResolvedJavaMethod)method, arguments, jsBodyStamp, state, bci, (ResolvedJavaMethod)exceptionHandler).asNode();
        returnValue = JSStubMethod.convertReturnValue(kit, returnValue, returnType, rawCall, coercion);
        kit.createReturn(returnValue, returnType.getJavaKind());
        return kit.finalizeGraph();
    }

    private static ValueNode convertArgument(HostedGraphKit kit, ValueNode initialArgument, AnalysisType paramType, boolean rawCall, boolean coercion) {
        ValueNode argument = initialArgument;
        if (rawCall) {
            return argument;
        }
        if (paramType.isPrimitive()) {
            argument = kit.createBoxing(argument, paramType.getJavaKind(), (ResolvedJavaType)JSStubMethod.boxedTypeFor(kit, paramType.getJavaKind()));
        }
        if (coercion) {
            try {
                AnalysisMethod coerceJavaToJavaScriptMethod = kit.getMetaAccess().lookupJavaMethod((Executable)JSConversion.class.getDeclaredMethod("coerceJavaToJavaScript", Object.class));
                argument = kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)coerceJavaToJavaScriptMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{argument});
            }
            catch (NoSuchMethodException e) {
                throw JVMCIError.shouldNotReachHere((Throwable)e);
            }
        }
        try {
            AnalysisMethod javaToJavaScriptMethod = kit.getMetaAccess().lookupJavaMethod((Executable)JSConversion.class.getDeclaredMethod("javaToJavaScript", Object.class));
            argument = kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)javaToJavaScriptMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{argument});
        }
        catch (NoSuchMethodException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
        return argument;
    }

    private static AnalysisType boxedTypeFor(HostedGraphKit kit, JavaKind kind) {
        Class boxedType = kind.toBoxedJavaClass();
        assert (boxedType != null) : "Unexpected kind: " + String.valueOf(kind);
        return kit.getMetaAccess().lookupJavaType(boxedType);
    }

    private static ValueNode convertReturnValue(HostedGraphKit kit, ValueNode jsBody, AnalysisType returnType, boolean rawCall, boolean coercion) {
        ValueNode returnValue = jsBody;
        if (returnType.getJavaKind() == JavaKind.Void) {
            return null;
        }
        if (rawCall) {
            return returnValue;
        }
        AnalysisType referenceReturnType = returnType.isPrimitive() ? JSStubMethod.boxedTypeFor(kit, returnType.getJavaKind()) : returnType;
        try {
            AnalysisMethod javaScriptToJavaMethod = kit.getMetaAccess().lookupJavaMethod((Executable)JSConversion.class.getDeclaredMethod("javaScriptToJava", Object.class));
            returnValue = kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)javaScriptToJavaMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{returnValue});
        }
        catch (NoSuchMethodException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
        if (coercion) {
            try {
                AnalysisMethod coerceJavaScriptToJavaMethod = kit.getMetaAccess().lookupJavaMethod((Executable)JSConversion.class.getDeclaredMethod("coerceJavaScriptToJava", Object.class, Class.class));
                Stamp classStamp = StampFactory.forDeclaredType(null, (JavaType)kit.getMetaAccess().lookupJavaType(Class.class), (boolean)true).getTrustedStamp();
                ConstantNode hub = ConstantNode.forConstant((Stamp)classStamp, (Constant)kit.getConstantReflection().asObjectHub((ResolvedJavaType)referenceReturnType), (MetaAccessProvider)kit.getMetaAccess(), (StructuredGraph)kit.getGraph());
                returnValue = kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)coerceJavaScriptToJavaMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{returnValue, hub});
            }
            catch (NoSuchMethodException e) {
                throw JVMCIError.shouldNotReachHere((Throwable)e);
            }
        }
        try {
            TypeReference referenceReturnTypeRef = TypeReference.createTrusted(null, (ResolvedJavaType)referenceReturnType);
            LogicNode instanceOf = InstanceOfNode.createAllowNull((TypeReference)referenceReturnTypeRef, (ValueNode)returnValue, null, null);
            IfNode ifNode = kit.startIf(instanceOf, ProfileData.BranchProbabilityData.injected((double)0.9999));
            kit.elsePart();
            AnalysisMethod throwClassCastExceptionMethod = kit.getMetaAccess().lookupJavaMethod((Executable)JSConversion.class.getDeclaredMethod("throwClassCastExceptionForClass", Object.class, Class.class));
            ConstantNode classValue = ConstantNode.forConstant((JavaConstant)kit.getConstantReflection().asJavaClass((ResolvedJavaType)referenceReturnType), (MetaAccessProvider)kit.getMetaAccess(), (StructuredGraph)kit.getGraph());
            kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)throwClassCastExceptionMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{returnValue, classValue});
            kit.append((Node)new DeadEndNode());
            kit.thenPart();
            kit.endIf();
            returnValue = PiNode.create((ValueNode)returnValue, (Stamp)returnValue.stamp(NodeView.DEFAULT).join((Stamp)StampFactory.object((TypeReference)referenceReturnTypeRef)), (ValueNode)ifNode.trueSuccessor());
        }
        catch (NoSuchMethodException e) {
            throw JVMCIError.shouldNotReachHere((Throwable)e);
        }
        if (returnType.isPrimitive()) {
            returnValue = kit.createUnboxing(returnValue, returnType.getJavaKind());
        }
        return returnValue;
    }
}

