/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.svm.webimage.functionintrinsics.JSFunctionDefinition;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class JSStaticMethodDefinition
implements JSFunctionDefinition {
    protected ResolvedJavaMethod method;

    public JSStaticMethodDefinition(ResolvedJavaMethod method) {
        this.method = method;
    }

    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    public void setMethod(ResolvedJavaMethod method) {
        this.method = method;
    }

    @Override
    public int getNrOfArgs() {
        return this.method.getSignature().getParameterCount(false);
    }

    @Override
    public boolean isStatic() {
        return this.method.isStatic();
    }

    @Override
    public void emitReference(CodeGenTool jsLTools) {
        jsLTools.genStaticMethodReference(this.method);
    }

    @Override
    public void emitCall(CodeGenTool jsLTools, IEmitter ... params) {
        jsLTools.genStaticCall(this.method, params);
    }

    public String toString() {
        return "JSStaticMethodDefinition[" + String.valueOf(this.method) + "]";
    }
}

