/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.webimage.js.JSObjectAccessMethod;
import com.oracle.svm.hosted.webimage.js.JSObjectAccessMethodHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.util.Digest;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.webimage.api.JSObject;

@AutomaticallyRegisteredImageSingleton
public class JSObjectAccessMethodSupport {
    private final Map<AccessorDescription, JSObjectAccessMethod> accessMethods = new ConcurrentHashMap<AccessorDescription, JSObjectAccessMethod>();

    public static JSObjectAccessMethodSupport singleton() {
        return (JSObjectAccessMethodSupport)ImageSingletons.lookup(JSObjectAccessMethodSupport.class);
    }

    public AnalysisMethod lookupLoadMethod(AnalysisMetaAccess aMetaAccess, AnalysisField field) {
        return this.lookup(aMetaAccess, field, true);
    }

    public AnalysisMethod lookupStoreMethod(AnalysisMetaAccess aMetaAccess, AnalysisField field) {
        return this.lookup(aMetaAccess, field, false);
    }

    private AnalysisMethod lookup(AnalysisMetaAccess aMetaAccess, AnalysisField field, boolean isLoad) {
        GraalError.guarantee((boolean)JSObject.class.isAssignableFrom(field.getDeclaringClass().getJavaClass()), (String)"Field must be in JSObject class: %s", (Object)field);
        GraalError.guarantee((!field.isStatic() ? 1 : 0) != 0, (String)"Field must not be static: %s", (Object)field);
        UserError.guarantee((!field.isFinal() ? 1 : 0) != 0, (String)"Instance fields in subclasses of %s must not be final: %s", (Object[])new Object[]{JSObject.class.getSimpleName(), field.format("%H.%n")});
        UserError.guarantee((field.isPublic() || field.isProtected() ? 1 : 0) != 0, (String)"Only public and protected instance fields in subclasses of %s are allowed: %s", (Object[])new Object[]{JSObject.class.getSimpleName(), field.format("%H.%n")});
        JSObjectAccessMethod accessMethod = this.accessMethods.computeIfAbsent(new AccessorDescription(field, isLoad), key -> JSObjectAccessMethodSupport.createAccessMethod(aMetaAccess, field, isLoad));
        return aMetaAccess.getUniverse().lookup((JavaMethod)accessMethod);
    }

    private static JSObjectAccessMethod createAccessMethod(AnalysisMetaAccess metaAccess, AnalysisField field, boolean isLoad) {
        ResolvedJavaType unwrappedFieldDeclaringClass = field.getDeclaringClass().getWrapped();
        ResolvedJavaType unwrappedFieldType = field.getType().getWrapped();
        ResolvedSignature signature = isLoad ? ResolvedSignature.fromArray((ResolvedJavaType[])new ResolvedJavaType[]{unwrappedFieldDeclaringClass}, (ResolvedJavaType)unwrappedFieldType) : ResolvedSignature.fromArray((ResolvedJavaType[])new ResolvedJavaType[]{unwrappedFieldDeclaringClass, unwrappedFieldType}, (ResolvedJavaType)metaAccess.lookupJavaType(Void.TYPE).getWrapped());
        ConstantPool pool = unwrappedFieldDeclaringClass.getDeclaredConstructors(false)[0].getConstantPool();
        String name = JSObjectAccessMethodSupport.accessMethodName(field, isLoad);
        ResolvedJavaType unwrappedDeclaringClass = metaAccess.lookupJavaType(JSObjectAccessMethodHolder.class).getWrapped();
        return new JSObjectAccessMethod(name, (ResolvedJavaField)field, isLoad, unwrappedDeclaringClass, (Signature)signature, pool);
    }

    private static String accessMethodName(AnalysisField field, boolean isLoad) {
        String sb = field.getDeclaringClass().toClassName() + "." + field.getName();
        return (isLoad ? "get" : "set") + "_" + field.getDeclaringClass().getUnqualifiedName() + "_" + field.getName() + "_" + Digest.digest((String)sb);
    }

    record AccessorDescription(AnalysisField field, boolean isLoad) {
    }
}

