/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.webimage.js.JSBody;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class JSObjectAccessMethod
extends NonBytecodeMethod {
    private final ResolvedJavaField targetField;
    private final boolean isLoad;
    private JSBody.JSCode jsCode = null;

    public JSObjectAccessMethod(String name, ResolvedJavaField targetField, boolean isLoad, ResolvedJavaType declaringClass, Signature signature, ConstantPool constantPool) {
        super(name, true, declaringClass, signature, constantPool);
        this.targetField = targetField;
        this.isLoad = isLoad;
    }

    private JSBody.JSCode buildJSCode() {
        String fieldAccess = "object." + this.targetField.getName();
        String body = this.isLoad ? "return " + fieldAccess + ";" : fieldAccess + " = value;";
        return new JSBody.JSCode(new String[]{"object", "value"}, body);
    }

    public JSBody.JSCode getJSCode() {
        if (this.jsCode == null) {
            this.jsCode = this.buildJSCode();
        }
        return this.jsCode;
    }

    public boolean isLoad() {
        return this.isLoad;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        throw GraalError.shouldNotReachHere((String)"This should never be called. This is a 'native' method that is substituted");
    }

    public int getModifiers() {
        return 0x100 | super.getModifiers();
    }
}

