/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.js.JSBodyNode;
import java.util.function.Function;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN, sizeRationale="Is replaced with JS code in JavaScriptBody and JS annotations")
public final class JSBodyWithExceptionNode
extends WithExceptionNode
implements SingleMemoryKill,
StateSplit,
JSBody {
    public static final NodeClass<JSBodyWithExceptionNode> TYPE = NodeClass.create(JSBodyWithExceptionNode.class);
    @Node.Input
    private NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    private final JSBody.JSCode jsCode;
    private final ResolvedJavaMethod m;
    private final boolean declaresJSResources;
    private final Function<CodeGenTool, String> codeSupplier;

    public JSBodyWithExceptionNode(JSBody.JSCode jsCode, ResolvedJavaMethod m, ValueNode[] arguments, Stamp returnStamp, ExceptionObjectNode exceptionObject, boolean declaresJSResources) {
        this(jsCode, m, arguments, returnStamp, exceptionObject, declaresJSResources, x -> jsCode.getBody());
    }

    public JSBodyWithExceptionNode(JSBody.JSCode jsCode, ResolvedJavaMethod m, ValueNode[] arguments, Stamp returnStamp, ExceptionObjectNode exceptionObject, boolean declaresJSResources, Function<CodeGenTool, String> codeSupplier) {
        super(TYPE, returnStamp);
        assert (jsCode != null);
        this.jsCode = jsCode;
        this.m = m;
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.exceptionEdge = exceptionObject;
        this.declaresJSResources = declaresJSResources;
        this.codeSupplier = codeSupplier;
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    @Override
    public JSBody.JSCode getJsCode() {
        return this.jsCode;
    }

    @Override
    public String getJSCodeAsString(CodeGenTool codeGenTool) {
        return this.codeSupplier.apply(codeGenTool);
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return this.m;
    }

    @Override
    public boolean declaresJSResources() {
        return this.declaresJSResources;
    }

    public FrameState stateAfter() {
        return this.stateAfter;
    }

    public void setStateAfter(FrameState stateAfter) {
        this.updateUsages((Node)this.stateAfter, (Node)stateAfter);
        this.stateAfter = stateAfter;
    }

    public FixedNode replaceWithNonThrowing() {
        JSBodyNode jsBody = (JSBodyNode)this.asNode().graph().add((Node)new JSBodyNode(this.jsCode, this.m, (ValueNode[])this.arguments.toArray((Object[])ValueNode.EMPTY_ARRAY), this.stamp, this.declaresJSResources, this.codeSupplier));
        jsBody.setStateAfter(this.stateAfter());
        AbstractBeginNode nextBegin = this.next;
        AbstractBeginNode oldException = this.exceptionEdge;
        this.graph().replaceSplitWithFixed((ControlSplitNode)this, (FixedWithNextNode)jsBody, nextBegin);
        GraphUtil.killCFG((FixedNode)oldException);
        return jsBody;
    }
}

