/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.js;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.webimage.js.JSBodyNode;
import com.oracle.svm.hosted.webimage.js.JSBodyWithExceptionNode;
import java.util.Arrays;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.nodes.FixedNodeInterface;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.webimage.api.JS;
import org.graalvm.word.LocationIdentity;

public sealed interface JSBody
extends SingleMemoryKill,
StateSplit,
FixedNodeInterface
permits JSBodyNode, JSBodyWithExceptionNode {
    default public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    default public boolean hasSideEffect() {
        return true;
    }

    public NodeInputList<ValueNode> getArguments();

    public JSCode getJsCode();

    public String getJSCodeAsString(CodeGenTool var1);

    public ResolvedJavaMethod getMethod();

    public boolean declaresJSResources();

    public static class JSCode {
        private final String[] args;
        private final String body;

        public JSCode(String[] args, String body) {
            this.args = args;
            this.body = body;
        }

        public JSCode(JS js, ResolvedJavaMethod m) {
            this(JSCode.getParameterNames(js.args(), m), js.value());
        }

        private static String[] getParameterNames(String[] explicitNames, ResolvedJavaMethod m) {
            if (explicitNames.length == 1 && explicitNames[0].equals("")) {
                ResolvedJavaMethod.Parameter[] parameters = m.getParameters();
                String[] parameterNames = new String[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    ResolvedJavaMethod.Parameter param = parameters[i];
                    UserError.guarantee((boolean)param.isNamePresent(), (String)"Cannot infer argument names for @%s annotation. Either explicitly specify argument names or compile the target method with the '-parameters' flag: %s", (Object[])new Object[]{JS.class.getSimpleName(), m});
                    parameterNames[i] = param.getName();
                }
                return parameterNames;
            }
            return explicitNames;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return "JSCode{args=" + Arrays.toString(this.args) + ", body='" + this.body + "'}";
        }
    }
}

