/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.jni.JNIGeneratedMethodSupport;
import com.oracle.svm.core.jni.access.JNINativeLinkage;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.webimage.phases.WebImageHostedGraphKit;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class WebImageJSJNINativeCallWrapperMethod
extends CustomSubstitutionMethod {
    private final JNINativeLinkage linkage;

    public WebImageJSJNINativeCallWrapperMethod(ResolvedJavaMethod original) {
        super(original);
        this.linkage = WebImageJSJNINativeCallWrapperMethod.createLinkage(original);
    }

    private static JNINativeLinkage createLinkage(ResolvedJavaMethod method) {
        ResolvedJavaMethod unwrapped = method;
        while (unwrapped instanceof WrappedJavaMethod) {
            unwrapped = ((WrappedJavaMethod)unwrapped).getWrapped();
        }
        String className = unwrapped.getDeclaringClass().getName();
        String descriptor = unwrapped.getSignature().toMethodDescriptor();
        return JNIAccessFeature.singleton().makeLinkage(className, unwrapped.getName(), descriptor);
    }

    public boolean isSynthetic() {
        return true;
    }

    public int getModifiers() {
        int synthetic = 4096;
        return (this.getOriginal().getModifiers() | 0x1000) & 0xFFFFFEDF;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        WebImageHostedGraphKit kit = new WebImageHostedGraphKit(debug, providers, (ResolvedJavaMethod)method, purpose);
        AnalysisType javaReturnType = (AnalysisType)method.getSignature().getReturnType();
        if (this.linkage.isBuiltInFunction()) {
            throw VMError.unsupportedFeature((String)"Builtin library functions not yet supported.");
        }
        InvokeWithExceptionNode callAddress = WebImageJSJNINativeCallWrapperMethod.nativeCallAddress(kit, (ValueNode)kit.createObject(this.linkage));
        ArrayList<Object> jniArguments = new ArrayList<Object>();
        ArrayList<AnalysisType> jniArgumentTypes = new ArrayList<AnalysisType>();
        ConstantNode environment = kit.createConstant((Constant)JavaConstant.NULL_POINTER, JavaKind.Object);
        AnalysisType environmentType = kit.getMetaAccess().lookupJavaType(JNIEnvironment.class);
        jniArguments.add(environment);
        jniArgumentTypes.add(environmentType);
        if (method.isStatic()) {
            JavaConstant clazz = kit.getConstantReflection().asJavaClass((ResolvedJavaType)method.getDeclaringClass());
            ConstantNode clazzNode = ConstantNode.forConstant((JavaConstant)clazz, (MetaAccessProvider)kit.getMetaAccess(), (StructuredGraph)kit.getGraph());
            jniArguments.add(clazzNode);
            jniArgumentTypes.add(kit.getMetaAccess().lookupJavaType(Class.class));
        }
        List javaArgumentTypes = method.toParameterList();
        List javaArguments = kit.getInitialArguments();
        for (int i = 0; i < javaArguments.size(); ++i) {
            ValueNode arg = (ValueNode)javaArguments.get(i);
            AnalysisType argType = (AnalysisType)javaArgumentTypes.get(i);
            ValueNode jsArg = kit.createConvertToJs(arg, argType.getJavaKind());
            jniArguments.add(jsArg);
            jniArgumentTypes.add(argType);
        }
        AnalysisType jniReturnType = javaReturnType;
        switch (jniReturnType.getJavaKind()) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: {
                jniReturnType = kit.getMetaAccess().lookupJavaType(Integer.TYPE);
            }
        }
        ResolvedSignature jniSignature = ResolvedSignature.fromList(jniArgumentTypes, (ResolvedJavaType)jniReturnType);
        InvokeNode returnValue = kit.createIndirectCall((ValueNode)callAddress, jniArguments, (Signature)jniSignature, SubstrateCallingConventionKind.Java);
        kit.createReturn((ValueNode)returnValue, javaReturnType.getJavaKind());
        return kit.finalizeGraph();
    }

    public static InvokeWithExceptionNode nativeCallAddress(WebImageHostedGraphKit kit, ValueNode linkageObject) {
        ResolvedJavaMethod method = kit.findMethod(JNIGeneratedMethodSupport.class, "nativeCallAddress", true);
        int invokeBci = kit.bci();
        return kit.createInvokeWithExceptionAndUnwind(method, CallTargetNode.InvokeKind.Static, kit.getFrameState(), invokeBci, new ValueNode[]{linkageObject});
    }
}

