/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.compiletasks;

import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.phases.PrepareLongEmulationPhase;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;

public class Long64PreparationTask
implements CompletionExecutor.DebugContextRunnable {
    private final HostedMethod method;
    private final CoreProviders providers;
    private final OptionValues options;

    public Long64PreparationTask(HostedMethod method, CoreProviders providers, OptionValues options) {
        this.method = method;
        this.providers = providers;
        this.options = options;
    }

    public void run(DebugContext debug) {
        StructuredGraph graph = this.method.compilationInfo.createGraph(debug, this.options, (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
        try (DebugContext.Scope s = debug.scope((Object)"(prepare long64)", (Object)graph, (Object)this.method, (Object)this);){
            new PrepareLongEmulationPhase().apply(graph, this.providers);
            CanonicalizerPhase.create().apply(graph, (Object)this.providers);
            this.method.compilationInfo.encodeGraph(graph);
        }
        catch (Throwable throwable) {
            throw debug.handle(throwable);
        }
    }
}

