/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.wrappers;

import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.codegen.long64.Long64Lowerer;
import com.oracle.svm.hosted.webimage.js.JSStaticMethodDefinition;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import com.oracle.svm.webimage.object.ObjectInspector;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class JSEmitter
implements IEmitter {
    private final Consumer<JSCodeGenTool> lowerer;

    protected JSEmitter(Consumer<JSCodeGenTool> lowerer) {
        this.lowerer = lowerer;
    }

    public void lower(CodeGenTool codeGenTool) {
        this.lowerer.accept((JSCodeGenTool)codeGenTool);
    }

    public static JSEmitter intPaladin(IEmitter inner) {
        return new JSEmitter(t -> {
            t.genNumericalPaladinIntLeft();
            inner.lower((CodeGenTool)t);
            t.genNumericalPaladinIntRight();
        });
    }

    public static JSEmitter of(Consumer<JSCodeGenTool> lowerer) {
        return new JSEmitter(lowerer);
    }

    public static JSEmitter of(Long l) {
        Objects.requireNonNull(l);
        return new JSEmitter(t -> Long64Lowerer.lowerSubstitutedDeclaration(t, l));
    }

    public static JSEmitter of(PrimitiveConstant c) {
        Objects.requireNonNull(c);
        return new JSEmitter(t -> WebImageJSNodeLowerer.lowerConstant(c, t));
    }

    public static JSEmitter of(ConstantIdentityMapping.IdentityNode node) {
        Objects.requireNonNull(node);
        return new JSEmitter(t -> t.getCodeBuffer().emitText(node.requestName()));
    }

    public static IEmitter of(ObjectInspector.ValueType v) {
        Objects.requireNonNull(v);
        return JSEmitter.of(v.getConstant());
    }

    public static IEmitter of(ObjectInspector.MethodPointerType ptr) {
        return JSEmitter.of(ptr.getIndex());
    }

    public static JSEmitter of(JSStaticMethodDefinition methodDefinition) {
        return new JSEmitter(methodDefinition::emitReference);
    }

    public static JSEmitter ofMethodReference(ResolvedJavaMethod m) {
        Objects.requireNonNull(m);
        return new JSEmitter(t -> {
            if (m.isStatic()) {
                t.genStaticMethodReference(m);
            } else {
                t.genPrototypeMethodReference(m);
            }
        });
    }
}

