/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.value;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public class ResolvedVarLowerer {
    public static void lower(ResolvedVar var, CodeGenTool codeGenTool) {
        if (((Boolean)WebImageOptions.GenerateSourceMap.getValue(HostedOptionValues.singleton())).booleanValue()) {
            ((JSCodeBuffer)codeGenTool.getCodeBuffer()).markSymbol(ResolvedVarLowerer.getVarName(var.getOrig(), ((ValueNode)var.getOrig()).graph().method(), var.getName()));
        }
        codeGenTool.genResolvedVarAccess(var.getName());
    }

    public static String getVarName(Node valueNode, ResolvedJavaMethod method, String tmpName) {
        LocalVariableTable tab = method.getLocalVariableTable();
        if (tab == null) {
            return ResolvedVarLowerer.varNameFallback(valueNode, method, "{no debug info} " + tmpName);
        }
        EconomicSet results = EconomicSet.create();
        String messageIfNone = "{temporary} ";
        for (FrameState frameState : valueNode.usages().filter(FrameState.class).snapshot()) {
            if (!frameState.getMethod().equals((Object)method)) continue;
            int numSlots = frameState.localsSize();
            for (int slot = 0; slot < numSlots; ++slot) {
                if (frameState.localAt(slot) != valueNode) continue;
                Local local = tab.getLocal(slot, frameState.bci);
                if (local == null) {
                    messageIfNone = "{error} ";
                    continue;
                }
                String name = local.getName();
                if (name == null || results.contains((Object)name)) continue;
                results.add((Object)local.getName());
            }
        }
        if (!results.isEmpty()) {
            return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)results);
        }
        return ResolvedVarLowerer.varNameFallback(valueNode, method, messageIfNone + tmpName);
    }

    private static String varNameFallback(Node valueNode, ResolvedJavaMethod method, String fallbackName) {
        if (valueNode instanceof ParameterNode) {
            int index = ((ParameterNode)valueNode).index();
            if (!method.isStatic()) {
                if (index == 0) {
                    return "this?";
                }
                --index;
            }
            return method.getParameters()[index].getName() + "?";
        }
        return fallbackName;
    }
}

