/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.type;

import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.webimage.JSKeyword;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class TypeVtableLowerer {
    private final HostedType type;
    public static final String VTAB_PROP = "vt";

    public TypeVtableLowerer(HostedType type) {
        this.type = type;
    }

    public void lowerInitialDefinition(JSCodeGenTool jsLTools) {
        if (this.type.getVTable().length == 0) {
            return;
        }
        HostedMethod[] vtable = this.type.getVTable();
        CodeBuffer masm = jsLTools.getCodeBuffer();
        String vtableAccessName = jsLTools.getJSProviders().typeControl().requestTypeName((ResolvedJavaType)this.type) + ".vt";
        jsLTools.genResolvedVarAssignmentPrefix(vtableAccessName);
        masm.emitKeyword((Keyword)JSKeyword.LBRACK);
        for (HostedMethod hm : vtable) {
            if (hm != null) {
                masm.emitNewLine();
                jsLTools.genPrototypePropertyAccess((IEmitter)Emitter.of((ResolvedJavaType)hm.getDeclaringClass()), (IEmitter)Emitter.of((ResolvedJavaMethod)hm));
            }
            masm.emitText(",");
        }
        masm.emitNewLine();
        masm.emitKeyword((Keyword)JSKeyword.RBRACK);
        masm.emitInsEnd();
    }
}

