/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.type;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.List;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class InvokeLoweringUtil {
    private static void performCallOperation(WebImageCallType calltype, HostedMethod targetMethod, Invoke n, JSCodeGenTool jsLTools) {
        if (calltype == WebImageCallType.STATIC) {
            jsLTools.genStaticCall((ResolvedJavaMethod)targetMethod, (IEmitter[])Emitter.of((List)n.callTarget().arguments()));
        } else {
            switch (calltype.ordinal()) {
                case 3: {
                    if (((Boolean)WebImageOptions.UseVtable.getValue(HostedOptionValues.singleton())).booleanValue()) {
                        jsLTools.genFunctionCall((IEmitter)Emitter.of((ValueNode)n.getReceiver()), (IEmitter)Emitter.of((String)("constructor.vt[" + targetMethod.getVTableIndex() + "]")), (IEmitter[])Emitter.of((List)n.callTarget().arguments()));
                        break;
                    }
                    InvokeLoweringUtil.lowerDynamicJSCall(targetMethod, n, jsLTools);
                    break;
                }
                case 2: {
                    InvokeLoweringUtil.lowerDynamicJSCall(targetMethod, n, jsLTools);
                    break;
                }
                case 1: {
                    WebImageHostedConfiguration.get().getInvokeLoweringUtil().emitPrototypeCall(n, jsLTools);
                    break;
                }
                case 4: {
                    ValueNode address = ((IndirectCallTargetNode)n.callTarget()).computedAddress();
                    jsLTools.genIndirectCall((IEmitter)Emitter.of((ValueNode)address), (IEmitter[])Emitter.of((List)n.callTarget().arguments()));
                    break;
                }
                default: {
                    throw JVMCIError.shouldNotReachHere();
                }
            }
        }
    }

    private static void lowerDynamicJSCall(HostedMethod m, Invoke invoke, JSCodeGenTool jsLTools) {
        jsLTools.genFunctionCall((IEmitter)Emitter.of((ValueNode)invoke.getReceiver()), (IEmitter)Emitter.of((ResolvedJavaMethod)m), (IEmitter[])Emitter.of((List)invoke.callTarget().arguments()));
    }

    protected void emitPrototypeCall(Invoke n, JSCodeGenTool jsLTools) {
        jsLTools.genPrototypeCall(n.getTargetMethod(), (IEmitter[])Emitter.of((List)n.callTarget().arguments()));
    }

    public static void lowerOrPatchStatic(HostedMethod targetMethod, Invoke n, JSCodeGenTool jsLTools) {
        WebImageCallType calltype = InvokeLoweringUtil.getCallType(targetMethod, null, n);
        assert (calltype == WebImageCallType.STATIC) : calltype;
        InvokeLoweringUtil.performCallOperation(calltype, targetMethod, n, jsLTools);
    }

    public static void lowerOrPatchDynamic(HostedMethod targetMethod, HostedType receiverType, Invoke n, JSCodeGenTool jsLTools) {
        JVMCIError.guarantee((n.getInvokeKind() != CallTargetNode.InvokeKind.Static ? 1 : 0) != 0, (String)"Only Dynamic calls are allowed %s", (Object[])new Object[]{n.toString()});
        WebImageCallType calltype = InvokeLoweringUtil.getCallType(targetMethod, receiverType, n);
        assert (calltype != WebImageCallType.STATIC) : calltype;
        InvokeLoweringUtil.performCallOperation(calltype, targetMethod, n, jsLTools);
    }

    public static void lowerIndirect(Invoke node, JSCodeGenTool jsLTools) {
        InvokeLoweringUtil.performCallOperation(WebImageCallType.INDIRECT, null, node, jsLTools);
    }

    public static WebImageCallType getCallType(HostedMethod targetMethod, HostedType receiverType, Invoke n) {
        if (receiverType == null) {
            assert (n.getInvokeKind() == CallTargetNode.InvokeKind.Static) : n.getInvokeKind();
            return WebImageCallType.STATIC;
        }
        assert (n.getInvokeKind() != CallTargetNode.InvokeKind.Static) : n.getInvokeKind();
        if (n.getInvokeKind() == CallTargetNode.InvokeKind.Special) {
            return WebImageCallType.DYNAMIC_EARLY;
        }
        if (targetMethod.hasVTableIndex()) {
            return WebImageCallType.DYNAMIC_VTAB;
        }
        return WebImageCallType.DYNAMIC_NOVTAB;
    }

    public static enum WebImageCallType {
        STATIC,
        DYNAMIC_EARLY,
        DYNAMIC_NOVTAB,
        DYNAMIC_VTAB,
        INDIRECT;

    }
}

