/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.type;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.RuntimeConstants;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.util.ReflectUtil;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.api.Nothing;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.webimage.api.JSObject;

public class ClassMetadataLowerer {
    public static final String FIELD_TABLE_NAME = "ft";
    public static final String INSTANCE_TYPE_HASHCODE_FIELD_NAME = "__hc";
    public static final String CLASS_METADATA_CLASS = "ClassMetadata";
    public static final String CTOR_NAME = "<init>";

    private static boolean typeNeedsHashCodeField(HostedType t) {
        return t instanceof HostedInstanceClass;
    }

    private static boolean shouldNotGenerate(HostedType t) {
        HostedField[] fields = t.getInstanceFields(true);
        return fields.length == 0 && !ClassMetadataLowerer.typeNeedsHashCodeField(t);
    }

    public static int getFieldOffset(HostedField f) {
        if (!f.hasLocation()) {
            return -1;
        }
        SharedType metaType = f.getDeclaringClass().getHub().getMetaType();
        if (metaType != null) {
            for (ResolvedJavaField metafield : metaType.getInstanceFields(true)) {
                SubstrateField substrateMetafield = (SubstrateField)metafield;
                if (!substrateMetafield.getName().equals(f.getName())) continue;
                return substrateMetafield.getLocation();
            }
        }
        return f.getLocation();
    }

    private static Map<Integer, String> generateFieldMap(HostedType t, JSCodeGenTool tools) {
        if (ClassMetadataLowerer.shouldNotGenerate(t)) {
            return null;
        }
        HashMap<Integer, String> fieldMap = new HashMap<Integer, String>();
        for (HostedField f : t.getInstanceFields(true)) {
            int offset;
            if (JSObject.class.isAssignableFrom(t.getJavaClass()) || (offset = ClassMetadataLowerer.getFieldOffset(f)) < 0) continue;
            String fieldName = tools.getJSProviders().typeControl().requestFieldName((ResolvedJavaField)f);
            fieldMap.put(offset, fieldName);
        }
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        VMError.guarantee((boolean)ol.isIdentityHashFieldInObjectHeader());
        fieldMap.put(ol.getObjectHeaderIdentityHashOffset(), INSTANCE_TYPE_HASHCODE_FIELD_NAME);
        return fieldMap;
    }

    public static void lowerClassMetadata(HostedType t, JSCodeGenTool tools, Map<HostedMethod, StructuredGraph> methodGraphs) {
        JSCodeBuffer buffer = (JSCodeBuffer)tools.getCodeBuffer();
        buffer.emitScopeBegin();
        buffer.emitLetDeclPrefix("_");
        String className = tools.getJSProviders().typeControl().requestTypeName((ResolvedJavaType)t);
        buffer.emitText(RuntimeConstants.GET_CLASS_PROTOTYPE + "(" + className + ")");
        buffer.emitResolvedBuiltInVarDeclPostfix(null);
        buffer.emitText("lazy");
        buffer.emitKeyword(JSKeyword.LPAR);
        tools.genCommaList(new IEmitter[]{Emitter.of((ResolvedJavaType)t), Emitter.of((String)RuntimeConstants.CLASS_META_SYMBOL)});
        buffer.emitText(", () => ");
        buffer.emitNew();
        buffer.emitText(CLASS_METADATA_CLASS);
        buffer.emitKeyword(JSKeyword.LPAR);
        tools.genCommaList(new IEmitter[]{ClassMetadataLowerer.createAccessorMap(t, tools), ClassMetadataLowerer.createSingleAbstractMethod(t, tools, className), ClassMetadataLowerer.createMethodSignatures(t, tools, methodGraphs, className)});
        buffer.emitKeyword(JSKeyword.RPAR);
        buffer.emitKeyword(JSKeyword.RPAR);
        buffer.emitInsEnd();
        buffer.emitScopeEnd();
        buffer.emitNewLine();
    }

    private static Emitter createAccessorMap(HostedType t, JSCodeGenTool tools) {
        Map<Integer, String> fieldMap = ClassMetadataLowerer.generateFieldMap(t, tools);
        if (fieldMap == null) {
            return Emitter.of((String)"{}");
        }
        Map<Object, IEmitter> functionMap = fieldMap.entrySet().stream().map(e -> {
            String fieldName = (String)e.getValue();
            String function = "(s, v) => v !== " + RuntimeConstants.UNDEFINED + " ? s." + fieldName + " = v : s." + fieldName;
            return new AbstractMap.SimpleEntry<String, Emitter>(Integer.toString((Integer)e.getKey()), Emitter.of((String)function));
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return Emitter.ofObject(functionMap);
    }

    private static Emitter createSingleAbstractMethod(HostedType t, JSCodeGenTool tools, String className) {
        Optional sam = ReflectUtil.singleAbstractMethodForClass(tools.getProviders().getMetaAccess(), t);
        if (sam.isPresent()) {
            return ClassMetadataLowerer.methodMetadataEmitter(tools, className, (HostedMethod)sam.get());
        }
        return Emitter.of((String)RuntimeConstants.UNDEFINED);
    }

    private static Emitter createMethodSignatures(HostedType t, JSCodeGenTool tools, Map<HostedMethod, StructuredGraph> methodGraphs, String className) {
        if (!ClassMetadataLowerer.isInstantiatedOrSubclassInstantiated(t)) {
            return Emitter.of((String)RuntimeConstants.UNDEFINED);
        }
        HashMap methodGroups = new HashMap();
        for (HostedMethod method : t.getAllDeclaredMethods()) {
            if (!ClassMetadataLowerer.shouldEmitMetadata(method) || methodGraphs.get(method) == null) continue;
            ArrayList<Emitter> emitters = (ArrayList<Emitter>)methodGroups.get(method.getName());
            if (emitters == null) {
                emitters = new ArrayList<Emitter>();
                methodGroups.put(method.getName(), emitters);
            }
            Emitter methodMetadata = ClassMetadataLowerer.methodMetadataEmitter(tools, className, method);
            emitters.add(methodMetadata);
        }
        HashMap<String, Emitter> methods = new HashMap<String, Emitter>();
        for (Map.Entry entry : methodGroups.entrySet()) {
            ArrayList emitters = (ArrayList)entry.getValue();
            String key = (String)entry.getKey();
            methods.put((String)(key.equals(CTOR_NAME) ? Emitter.of((String)(RuntimeConstants.RUNTIME_SYMBOL + ".ctor")) : key), Emitter.ofArray((Emitter[])emitters.toArray(new Emitter[emitters.size()])));
        }
        return Emitter.ofObject(methods);
    }

    public static boolean isInstantiatedOrSubclassInstantiated(HostedType t) {
        return t.getWrapped().isAnySubtypeInstantiated();
    }

    public static boolean shouldEmitMetadata(HostedMethod method) {
        return method.isPublic() || method.isConstructor() && method.isPackagePrivate();
    }

    private static Emitter methodMetadataEmitter(JSCodeGenTool tools, String className, HostedMethod method) {
        WebImageTypeControl typeControl = tools.getJSProviders().typeControl();
        String generatedName = typeControl.requestMethodName((ResolvedJavaMethod)method);
        ResolvedSignature signature = method.getSignature();
        StringBuilder argHubs = new StringBuilder();
        for (int i = 0; i < signature.getParameterCount(false); ++i) {
            argHubs.append(", ");
            argHubs.append(ClassMetadataLowerer.hubNameFor(tools, (HostedType)signature.getParameterType(i, null)));
        }
        String returnHub = ClassMetadataLowerer.hubNameFor(tools, (HostedType)signature.getReturnType(null));
        Emitter methodMetadata = method.isStatic() ? Emitter.of((String)("smmeta(" + className + "." + generatedName + ", " + returnHub + String.valueOf(argHubs) + ")")) : Emitter.of((String)("mmeta(_." + generatedName + ", " + returnHub + String.valueOf(argHubs) + ")"));
        return methodMetadata;
    }

    private static String hubNameFor(JSCodeGenTool tools, HostedType type) {
        WebImageTypeControl typeControl = tools.getJSProviders().typeControl();
        if (type.getWrapped().isReachable()) {
            return typeControl.requestHubName((ResolvedJavaType)type);
        }
        ResolvedJavaType nothingHub = tools.getProviders().getMetaAccess().lookupJavaType(Nothing.class);
        return typeControl.requestHubName(nothingHub);
    }
}

