/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import java.util.List;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.Phase;

public class RemoveUnusedVPPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (LoopExitNode exit : graph.getNodes(LoopExitNode.TYPE)) {
            FrameState stateAfter = exit.stateAfter();
            if (stateAfter == null) continue;
            exit.setStateAfter(null);
            if (!stateAfter.usages().isEmpty()) continue;
            GraphUtil.killWithUnusedFloatingInputs((Node)stateAfter);
        }
        for (LoopExitNode exit : graph.getNodes(LoopExitNode.TYPE)) {
            block2: for (ProxyNode proxy : exit.proxies().snapshot()) {
                if (RemoveUnusedVPPhase.hasNonFrameStateUsages(proxy)) continue;
                for (Node usage : proxy.usages().snapshot()) {
                    if (!(usage instanceof FrameState) || usage.usages().count() != 0) continue block2;
                    FrameState f = (FrameState)usage;
                    f.safeDelete();
                }
                proxy.safeDelete();
            }
        }
    }

    private static boolean hasNonFrameStateUsages(ProxyNode proxy) {
        List usages = proxy.usages().snapshot();
        for (Node usage : usages) {
            if (usage instanceof FrameState) continue;
            return true;
        }
        return false;
    }
}

