/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.phases.Phase;

public class RemoveUnusedExitsPhase
extends Phase {
    private static <T extends ControlSinkNode> void removeExit(ControlSinkNode ctrlSinkNode) {
        if (ctrlSinkNode.predecessor() instanceof LoopExitNode) {
            LoopExitNode lex = (LoopExitNode)ctrlSinkNode.predecessor();
            assert (lex.proxies().isEmpty()) : lex.proxies().snapshot();
            if (ctrlSinkNode.predecessor().predecessor() instanceof FixedWithNextNode) {
                FixedWithNextNode uww = (FixedWithNextNode)ctrlSinkNode.predecessor().predecessor();
                ControlSinkNode newControlSink = (ControlSinkNode)ctrlSinkNode.graph().addWithoutUnique((Node)RemoveUnusedExitsPhase.createNewControlSinkNode(ctrlSinkNode, RemoveUnusedExitsPhase.getInput(ctrlSinkNode)));
                lex.setNext(null);
                uww.setNext((FixedNode)newControlSink);
                ctrlSinkNode.safeDelete();
                lex.safeDelete();
            } else if (ctrlSinkNode.predecessor().predecessor() instanceof IfNode) {
                lex.graph().replaceFixedWithFixed((FixedWithNextNode)lex, (FixedWithNextNode)lex.graph().add((Node)new BeginNode()));
            }
        }
    }

    private static <T extends ControlSinkNode> ValueNode getInput(T controlSinkNode) {
        assert (controlSinkNode instanceof ReturnNode || controlSinkNode instanceof UnwindNode) : controlSinkNode;
        if (controlSinkNode instanceof ReturnNode) {
            return ((ReturnNode)controlSinkNode).result();
        }
        return ((UnwindNode)controlSinkNode).exception();
    }

    private static <T extends ControlSinkNode> ControlSinkNode createNewControlSinkNode(T oldControlSinkNode, ValueNode input) {
        assert (oldControlSinkNode instanceof ReturnNode || oldControlSinkNode instanceof UnwindNode) : oldControlSinkNode;
        if (oldControlSinkNode instanceof ReturnNode) {
            return new ReturnNode(input);
        }
        return new UnwindNode(input);
    }

    protected void run(StructuredGraph graph) {
        for (UnwindNode uwind : graph.getNodes(UnwindNode.TYPE)) {
            RemoveUnusedExitsPhase.removeExit((ControlSinkNode)uwind);
        }
        for (ReturnNode ret : graph.getNodes(ReturnNode.TYPE)) {
            RemoveUnusedExitsPhase.removeExit((ControlSinkNode)ret);
        }
        ControlFlowGraph cfg = ControlFlowGraph.newBuilder((StructuredGraph)graph).connectBlocks(true).computeFrequency(true).build();
        for (LoopExitNode loopExitNode : graph.getNodes(LoopExitNode.TYPE)) {
            HIRBlock loopExitBlock = cfg.blockFor((Node)loopExitNode);
            if (loopExitBlock.getSuccessorCount() != 0) continue;
            BeginNode beginNode = new BeginNode();
            graph.add((Node)beginNode);
            graph.replaceFixedWithFixed((FixedWithNextNode)loopExitNode, (FixedWithNextNode)beginNode);
        }
    }
}

