/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.graal.compiler.phases.Phase;

public class RemoveAllocateWithExceptionPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (AllocateWithExceptionNode n : graph.getNodes().filter(AllocateWithExceptionNode.class)) {
            n.replaceWithNonThrowing();
        }
        assert (RemoveAllocateWithExceptionPhase.checkNodes(graph));
    }

    private static boolean checkNodes(StructuredGraph graph) {
        List nodes = graph.getNodes().filter(AllocateWithExceptionNode.class).snapshot();
        if (!nodes.isEmpty()) {
            Set classNames = nodes.stream().map(Object::getClass).map(Class::toString).collect(Collectors.toUnmodifiableSet());
            assert (false) : "These nodes have not been replaced with a non-throwing counterpart in replaceWithNonThrowing: " + String.valueOf(classNames);
        }
        return true;
    }
}

