/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import com.oracle.svm.webimage.annotation.StackifierVerification;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.hightiercodegen.reconstruction.ScheduleWithReconstructionResult;
import jdk.graal.compiler.hightiercodegen.reconstruction.StackifierData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;

public class ReconstructionVerificationPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders providers) {
        ReconstructionData reconstructionData = ((ScheduleWithReconstructionResult)graph.getLastSchedule()).reconstructionData();
        if (AnnotationAccess.getAnnotation((AnnotatedElement)graph.method(), StackifierVerification.class) != null) {
            ReconstructionVerificationPhase.verifyStackifier(graph, graph.method(), (StackifierData)reconstructionData, providers);
        }
    }

    private static void verifyStackifier(StructuredGraph g, ResolvedJavaMethod method, StackifierData stackData, CoreProviders providers) {
        StackifierVerification annot = (StackifierVerification)AnnotationAccess.getAnnotation((AnnotatedElement)method, StackifierVerification.class);
        if (stackData.getNrOfLabeledBlocks() != annot.expLabeledBlocks() || stackData.getNrThenScopes() != annot.expThenScopes() || stackData.getNrElseScopes() != annot.expElseScopes() || stackData.getNrLoopScopes() != annot.expLoopScopes() || stackData.getNrCatchScopes() != annot.expCatchScopes()) {
            String formatString = "Forward blocks %d %n Then scopes %d %n Else scopes %d %n Loop scopes %d %n Catch scopes %d %n";
            String expected = String.format(formatString, annot.expLabeledBlocks(), annot.expThenScopes(), annot.expElseScopes(), annot.expLoopScopes(), annot.expCatchScopes());
            String actual = String.format(formatString, stackData.getNrOfLabeledBlocks(), stackData.getNrThenScopes(), stackData.getNrElseScopes(), stackData.getNrLoopScopes(), stackData.getNrCatchScopes());
            throw new GraalError("Stackifier control flow reconstruction algorithm did not perform as expected for method " + String.valueOf(g.method()) + "\nExpected: " + expected + "\nActual: " + actual);
        }
    }
}

