/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.webimage.functionintrinsics.ImplicitExceptions;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;

public class OutlineRuntimeChecksPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders providers) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (BytecodeExceptionNode node : graph.getNodes().filter(BytecodeExceptionNode.class)) {
            if (!(OutlineRuntimeChecksPhase.singleSuccessor((Node)node) instanceof UnwindNode)) continue;
            switch (node.getExceptionKind()) {
                case NULL_POINTER: {
                    NullCheckPattern.find((FixedNode)node, patterns);
                    break;
                }
                case OUT_OF_BOUNDS: {
                    ArrayBoundCheckPattern.find((FixedNode)node, patterns);
                    break;
                }
            }
        }
        for (BytecodeExceptionNode node : graph.getNodes().filter(ThrowBytecodeExceptionNode.class)) {
            switch (node.getExceptionKind()) {
                case NULL_POINTER: {
                    NullCheckPattern.find((FixedNode)node, patterns);
                    break;
                }
                case OUT_OF_BOUNDS: {
                    ArrayBoundCheckPattern.find((FixedNode)node, patterns);
                    break;
                }
            }
        }
        for (Pattern pattern : patterns) {
            pattern.replace(providers);
        }
        if (!patterns.isEmpty()) {
            CanonicalizerPhase.create().apply(graph, (Object)providers);
        }
    }

    private static FixedWithNextNode createOutlineCallNode(StructuredGraph graph, ForeignCallDescriptor descriptor, ValueNode[] args) {
        return (FixedWithNextNode)graph.add((Node)new ForeignCallNode(descriptor, args));
    }

    private static void replaceIfWith(IfNode ifNode, AbstractBeginNode survivingBranch, FixedWithNextNode outliningCall) {
        StructuredGraph graph = ifNode.graph();
        graph.removeSplitPropagate((ControlSplitNode)ifNode, survivingBranch);
        survivingBranch.replaceAtPredecessor((Node)outliningCall);
        outliningCall.setNext((FixedNode)survivingBranch);
    }

    private static Node singleSuccessor(Node node) {
        if (node.successors().count() == 1) {
            return node.successors().first();
        }
        return null;
    }

    private static Node singleInput(Node node) {
        if (node.inputs().count() == 1) {
            return node.inputs().first();
        }
        return null;
    }

    private static class NullCheckPattern
    extends Pattern {
        final IsNullNode isNullNode;
        final AbstractBeginNode falseSuccessor;

        NullCheckPattern(FixedNode bytecodeExceptionNode) {
            super(bytecodeExceptionNode);
            this.falseSuccessor = this.ifNode.falseSuccessor();
            this.isNullNode = (IsNullNode)this.ifNode.condition();
        }

        @Override
        void replace(CoreProviders providers) {
            if (this.ifNode.isDeleted()) {
                return;
            }
            StructuredGraph graph = this.ifNode.graph();
            ValueNode[] args = new ValueNode[]{this.isNullNode.getValue()};
            FixedWithNextNode outliningCall = OutlineRuntimeChecksPhase.createOutlineCallNode(graph, (ForeignCallDescriptor)ImplicitExceptions.CHECK_NULL_POINTER, args);
            OutlineRuntimeChecksPhase.replaceIfWith(this.ifNode, this.falseSuccessor, outliningCall);
        }

        static void find(FixedNode node, List<Pattern> patterns) {
            boolean isNullCheck = node.predecessor() instanceof BeginNode;
            isNullCheck = isNullCheck && node.predecessor().predecessor() instanceof IfNode;
            boolean bl = isNullCheck = isNullCheck && OutlineRuntimeChecksPhase.singleInput(node.predecessor().predecessor()) instanceof IsNullNode;
            if (isNullCheck) {
                NullCheckPattern pattern = new NullCheckPattern(node);
                patterns.add(pattern);
            }
        }
    }

    private static class ArrayBoundCheckPattern
    extends Pattern {
        final AbstractBeginNode survivingBranch;
        final LogicNode condition;
        final boolean isTrueBranchSurviving;

        ArrayBoundCheckPattern(FixedNode bytecodeExceptionNode) {
            super(bytecodeExceptionNode);
            this.condition = this.ifNode.condition();
            this.isTrueBranchSurviving = this.ifNode.falseSuccessor() == bytecodeExceptionNode.predecessor();
            this.survivingBranch = this.isTrueBranchSurviving ? this.ifNode.trueSuccessor() : this.ifNode.falseSuccessor();
        }

        @Override
        void replace(CoreProviders providers) {
            if (this.ifNode.isDeleted()) {
                return;
            }
            StructuredGraph graph = this.ifNode.graph();
            LogicNode invalidNode = this.isTrueBranchSurviving ? (LogicNode)graph.unique((Node)LogicNegationNode.create((LogicNode)this.condition)) : this.condition;
            ValueNode[] args = new ValueNode[]{(ValueNode)graph.unique((Node)new ConditionalNode(invalidNode))};
            FixedWithNextNode outliningCall = OutlineRuntimeChecksPhase.createOutlineCallNode(graph, (ForeignCallDescriptor)ImplicitExceptions.CHECK_ARRAY_BOUND, args);
            this.condition.removeUsage((Node)this.ifNode);
            OutlineRuntimeChecksPhase.replaceIfWith(this.ifNode, this.survivingBranch, outliningCall);
        }

        static void find(FixedNode node, List<Pattern> patterns) {
            boolean isBoundCheck = node.predecessor() instanceof BeginNode;
            boolean bl = isBoundCheck = isBoundCheck && node.predecessor().predecessor() instanceof IfNode;
            if (isBoundCheck) {
                ArrayBoundCheckPattern pattern = new ArrayBoundCheckPattern(node);
                patterns.add(pattern);
            }
        }
    }

    private static abstract class Pattern {
        protected final IfNode ifNode;

        Pattern(FixedNode bytecodeExceptionNode) {
            this.ifNode = (IfNode)bytecodeExceptionNode.predecessor().predecessor();
        }

        abstract void replace(CoreProviders var1);
    }
}

