/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.UnsafeAccessNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryLoadNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryStoreNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class NullUnsafeAccessPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (RawStoreNode node : graph.getNodes().filter(RawStoreNode.class)) {
            if (!NullUnsafeAccessPhase.canOptimize((UnsafeAccessNode)node)) continue;
            UnsafeMemoryStoreNode unsafeStore = (UnsafeMemoryStoreNode)graph.add((Node)new UnsafeMemoryStoreNode(node.offset(), node.value(), node.accessKind(), node.getLocationIdentity()));
            unsafeStore.setStateAfter(node.stateAfter());
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)unsafeStore);
        }
        for (RawStoreNode node : graph.getNodes().filter(RawLoadNode.class)) {
            if (!NullUnsafeAccessPhase.canOptimize((UnsafeAccessNode)node)) continue;
            UnsafeMemoryLoadNode unsafeLoad = (UnsafeMemoryLoadNode)graph.add((Node)new UnsafeMemoryLoadNode(node.offset(), node.accessKind(), node.getLocationIdentity()));
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)unsafeLoad);
        }
    }

    protected static boolean canOptimize(UnsafeAccessNode node) {
        AbstractObjectStamp objectStamp;
        Stamp stamp;
        ValueNode object = node.object();
        JavaKind kind = object.getStackKind();
        JavaConstant javaConstant = object.asJavaConstant();
        if (javaConstant != null && javaConstant.isDefaultForKind() && kind == JavaKind.Long) {
            assert (node.accessKind() != JavaKind.Object) : "Accessing object reference in raw memory";
            return true;
        }
        assert ((stamp = object.stamp(NodeView.DEFAULT)) instanceof AbstractObjectStamp && (objectStamp = (AbstractObjectStamp)stamp).nonNull()) : object.stamp(NodeView.DEFAULT);
        return false;
    }
}

