/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import com.oracle.svm.hosted.webimage.codegen.node.CompoundConditionNode;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.Phase;

public class IncrementalCompoundConditionalPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        int change = 1;
        block0: while (change > 0) {
            change = 0;
            for (IfNode ifnode : graph.getNodes(IfNode.TYPE).snapshot()) {
                if (!IncrementalCompoundConditionalPhase.isCompoundStatement(ifnode)) continue;
                ++change;
                continue block0;
            }
        }
    }

    private static boolean isCompoundStatement(IfNode ifnode) {
        try (DebugContext.Scope s = ifnode.getDebug().scope((Object)"Incremental Compound Conditional Removal Phase");){
            if (IncrementalCompoundConditionalPhase.xAAy(ifnode) != null) {
                LoggerContext.counter(MethodMetricKeys.NUM_COMPOUND_COND_XAAY).increment();
                boolean bl = true;
                return bl;
            }
            if (IncrementalCompoundConditionalPhase.xOOy(ifnode) != null) {
                LoggerContext.counter(MethodMetricKeys.NUM_COMPOUND_COND_XOOY).increment();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static IfNode xAAy(IfNode ifnode) {
        AbstractBeginNode trueSucc = ifnode.trueSuccessor();
        AbstractBeginNode falseSucc = ifnode.falseSuccessor();
        if (trueSucc instanceof LoopExitNode || falseSucc instanceof LoopExitNode) {
            return null;
        }
        if (falseSucc.next() instanceof EndNode) {
            AbstractMergeNode originalMergeFalse = ((EndNode)falseSucc.next()).merge();
            LogicNode originalCondition = ifnode.condition();
            if (trueSucc.next() instanceof IfNode) {
                AbstractMergeNode compoundMergeFalse;
                IfNode potentialCompoundIf = (IfNode)trueSucc.next();
                LogicNode potentialComoundCondition = potentialCompoundIf.condition();
                if (potentialCompoundIf.trueSuccessor() instanceof LoopExitNode || potentialCompoundIf.falseSuccessor() instanceof LoopExitNode) {
                    return null;
                }
                if (potentialCompoundIf.falseSuccessor().next() instanceof EndNode && originalMergeFalse.equals(compoundMergeFalse = ((EndNode)potentialCompoundIf.falseSuccessor().next()).merge()) && originalMergeFalse.forwardEndCount() == 2) {
                    if (!originalMergeFalse.forwardEnds().contains((Object)falseSucc.next()) || !originalMergeFalse.forwardEnds().contains((Object)potentialCompoundIf.falseSuccessor().next())) {
                        return null;
                    }
                    if (compoundMergeFalse.phis().count() > 0) {
                        return null;
                    }
                    AbstractBeginNode deadAbstractBeginNode = potentialCompoundIf.trueSuccessor();
                    FixedNode newCompoundTrueSucc = deadAbstractBeginNode.next();
                    FixedNode newCompoundFalseSucc = compoundMergeFalse.next();
                    if (newCompoundTrueSucc instanceof LoopEndNode || newCompoundFalseSucc instanceof LoopEndNode) {
                        return null;
                    }
                    ifnode.getDebug().dump(5, (Object)ifnode.graph(), "Before XaaY rewrite");
                    deadAbstractBeginNode.setNext(null);
                    compoundMergeFalse.setNext(null);
                    trueSucc.setNext(newCompoundTrueSucc);
                    deadAbstractBeginNode.replaceAtUsages((Node)trueSucc);
                    falseSucc.setNext(newCompoundFalseSucc);
                    ifnode.setCondition((LogicNode)ifnode.graph().addWithoutUnique((Node)new CompoundConditionNode(originalCondition, potentialComoundCondition, CompoundConditionNode.CompoundOp.XaaY)));
                    GraphUtil.killCFG((FixedNode)potentialCompoundIf);
                    ifnode.getDebug().dump(5, (Object)ifnode.graph(), "After XaaY rewrite");
                    return ifnode;
                }
            }
        }
        return null;
    }

    private static IfNode xOOy(IfNode ifnode) {
        AbstractBeginNode trueSucc = ifnode.trueSuccessor();
        AbstractBeginNode falseSucc = ifnode.falseSuccessor();
        if (trueSucc instanceof LoopExitNode || falseSucc instanceof LoopExitNode) {
            return null;
        }
        if (trueSucc.next() instanceof EndNode) {
            AbstractMergeNode originalMergeTrue = ((EndNode)trueSucc.next()).merge();
            LogicNode originalCondition = ifnode.condition();
            if (falseSucc.next() instanceof IfNode) {
                AbstractMergeNode compoundMergerTrue;
                IfNode potentialCompoundIf = (IfNode)falseSucc.next();
                LogicNode potentialComoundCondition = potentialCompoundIf.condition();
                if (potentialCompoundIf.trueSuccessor() instanceof LoopExitNode || potentialCompoundIf.falseSuccessor() instanceof LoopExitNode) {
                    return null;
                }
                if (potentialCompoundIf.trueSuccessor().next() instanceof EndNode && originalMergeTrue.equals(compoundMergerTrue = ((EndNode)potentialCompoundIf.trueSuccessor().next()).merge()) && originalMergeTrue.forwardEndCount() == 2) {
                    if (!originalMergeTrue.forwardEnds().contains((Object)trueSucc.next()) || !originalMergeTrue.forwardEnds().contains((Object)potentialCompoundIf.trueSuccessor().next())) {
                        return null;
                    }
                    if (compoundMergerTrue.phis().count() > 0) {
                        return null;
                    }
                    FixedNode newCompoundTrueSucc = compoundMergerTrue.next();
                    AbstractBeginNode deadAbstractBeginNode = potentialCompoundIf.falseSuccessor();
                    FixedNode newCompoundFalseSucc = deadAbstractBeginNode.next();
                    if (newCompoundTrueSucc instanceof LoopEndNode || newCompoundFalseSucc instanceof LoopEndNode) {
                        return null;
                    }
                    ifnode.getDebug().dump(5, (Object)ifnode.graph(), "After XooY rewrite");
                    deadAbstractBeginNode.setNext(null);
                    compoundMergerTrue.setNext(null);
                    trueSucc.setNext(newCompoundTrueSucc);
                    falseSucc.setNext(newCompoundFalseSucc);
                    deadAbstractBeginNode.replaceAtUsages((Node)falseSucc);
                    ifnode.setCondition((LogicNode)ifnode.graph().addWithoutUnique((Node)new CompoundConditionNode(originalCondition, potentialComoundCondition, CompoundConditionNode.CompoundOp.XooY)));
                    GraphUtil.killCFG((FixedNode)potentialCompoundIf);
                    ifnode.getDebug().dump(5, (Object)ifnode.graph(), "After XooY rewrite");
                    return ifnode;
                }
            }
        }
        return null;
    }
}

