/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import com.oracle.svm.hosted.webimage.codegen.phase.ExpandControlSinkUtil;
import java.util.List;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;

public class ExpandUnwindPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        try (Graph.NodeEventScope nes = graph.trackNodeEvents((Graph.NodeEventListener)listener);){
            List unwinds = graph.getNodes(UnwindNode.TYPE).snapshot();
            for (UnwindNode unwind : unwinds) {
                ExpandControlSinkUtil.distribute(unwind, graph);
            }
        }
        CanonicalizerPhase.create().applyIncremental(graph, context, (Iterable)listener.getNodes());
    }
}

