/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.phase;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;

class ExpandControlSinkUtil {
    ExpandControlSinkUtil() {
    }

    static <T extends ControlSinkNode> void distribute(T controlSinkNode, StructuredGraph g) {
        assert (controlSinkNode instanceof ReturnNode || controlSinkNode instanceof UnwindNode) : controlSinkNode;
        Node predecessor = controlSinkNode.predecessor();
        if (predecessor instanceof MergeNode) {
            MergeNode merge = (MergeNode)predecessor;
            NodeInputList ends = merge.forwardEnds();
            assert (ends != null);
            if (merge.phis().count() > 1) {
                return;
            }
            PhiNode phi = null;
            ValueNode controlSinkInput = ExpandControlSinkUtil.getInput(controlSinkNode);
            if (merge.phis().count() == 1) {
                phi = (PhiNode)merge.phis().first();
                if (controlSinkInput != null && !controlSinkInput.equals(phi)) {
                    return;
                }
                phi.replaceAtUsages(null);
            }
            for (AbstractEndNode end : ends) {
                ValueNode newInput = ExpandControlSinkUtil.getNewInput(controlSinkInput, merge, end, phi);
                ExpandControlSinkUtil.replaceControlSink(controlSinkNode, end, newInput, g);
            }
            merge.replaceAtUsages(null);
            if (phi != null) {
                phi.safeDelete();
            }
            merge.safeDelete();
            controlSinkNode.safeDelete();
        }
    }

    private static ValueNode getNewInput(ValueNode oldControlSinkInput, MergeNode merge, AbstractEndNode end, PhiNode phi) {
        if (oldControlSinkInput == null || oldControlSinkInput != phi) {
            return oldControlSinkInput;
        }
        int phiIndex = merge.phiPredecessorIndex(end);
        return phi.valueAt(phiIndex);
    }

    private static <T extends ControlSinkNode> void replaceControlSink(T controlSinkNode, AbstractEndNode end, ValueNode input, StructuredGraph g) {
        ControlSinkNode newControlSinkNode = ExpandControlSinkUtil.getNewControlSinkNode(controlSinkNode, input, g);
        ((FixedWithNextNode)end.predecessor()).setNext((FixedNode)newControlSinkNode);
        end.replaceAtUsages(null);
        end.safeDelete();
    }

    private static <T extends ControlSinkNode> ControlSinkNode getNewControlSinkNode(T controlSinkNode, ValueNode input, StructuredGraph g) {
        Object newControlSinkNode = controlSinkNode instanceof ReturnNode ? new ReturnNode(input) : new UnwindNode(input);
        return (ControlSinkNode)g.addWithoutUnique((Node)newControlSinkNode);
    }

    private static <T extends ControlSinkNode> ValueNode getInput(T controlSinkNode) {
        if (controlSinkNode instanceof ReturnNode) {
            return ((ReturnNode)controlSinkNode).result();
        }
        return ((UnwindNode)controlSinkNode).exception();
    }
}

