/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.oop;

import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.heap.ConstantMap;
import com.oracle.svm.hosted.webimage.codegen.wrappers.JSEmitter;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class StaticFieldLowerer {
    private final HostedType type;
    private final HashMap<HostedField, Constant> recursiveConstants;

    public StaticFieldLowerer(HostedType type, HashMap<HostedField, Constant> recursiveConstants) {
        this.type = type;
        this.recursiveConstants = recursiveConstants;
    }

    public static HashMap<HostedField, Constant> registerLowering(HostedType type, WebImageJSProviders providers) {
        HashMap<HostedField, Constant> recursiveConstants = new HashMap<HostedField, Constant>();
        for (ResolvedJavaField f : type.getStaticFields()) {
            HostedField hf = (HostedField)f;
            if (!hf.isRead()) continue;
            JavaConstant c = providers.getConstantReflection().readFieldValue((ResolvedJavaField)hf, null);
            if (!hf.getType().isPrimitive() && c.isNonNull() && !(c instanceof PrimitiveConstant)) {
                providers.typeControl().getConstantMap().resolveConstant(c);
            }
            recursiveConstants.put(hf, (Constant)c);
        }
        return recursiveConstants;
    }

    public void lower(JSCodeGenTool jsLTools) {
        for (Map.Entry<HostedField, Constant> entry : this.recursiveConstants.entrySet()) {
            JSEmitter value;
            HostedField f = entry.getKey();
            JavaConstant c = (JavaConstant)entry.getValue();
            if (c.getJavaKind().isPrimitive()) {
                value = JSEmitter.of((PrimitiveConstant)c);
            } else if (c.equals((Object)JavaConstant.NULL_POINTER)) {
                value = Emitter.ofNull();
            } else {
                ConstantMap constantMap = jsLTools.getJSProviders().typeControl().getConstantMap();
                value = Emitter.of((String)constantMap.resolveConstant(c));
            }
            jsLTools.getCodeBuffer().emitNewLine();
            jsLTools.genComment(f.format("static %T %H.%n"), WebImageOptions.CommentVerbosity.MINIMAL);
            jsLTools.genPropertyAccess((IEmitter)Emitter.of((ResolvedJavaType)this.type), (IEmitter)Emitter.of((ResolvedJavaField)f));
            jsLTools.genAssignment();
            value.lower(jsLTools);
            jsLTools.genResolvedVarDeclPostfix(null);
        }
    }
}

