/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.oop;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.RuntimeConstants;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.codegen.oop.ClassLowerer;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.snippets.JSSnippet;
import com.oracle.svm.hosted.webimage.snippets.JSSnippets;
import com.oracle.svm.hosted.webimage.util.metrics.MethodMetricsCollector;
import com.oracle.svm.webimage.JSKeyword;
import com.oracle.svm.webimage.Labeler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.Keyword;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.webimage.api.JS;
import org.graalvm.webimage.api.JSObject;

public class ClassWithMirrorLowerer
extends ClassLowerer {
    private static final String UNSPECIFIED_IMPORTED_NAME_VALUE = "";
    private final boolean isImportedClass;
    private final boolean isSourceIncluded;
    private final boolean isDirectSubclassOfImport;
    private final boolean isSubclassOfImport;
    private JSCodeGenTool.ExternClassDescriptor externClassDescriptor;

    public ClassWithMirrorLowerer(OptionValues options, DebugContext debug, JSCodeGenTool jsLTools, Map<HostedMethod, StructuredGraph> methodGraphs, Labeler labeler, MethodMetricsCollector methodMetricsCollector, Consumer<Integer> compiledMethodBytesCounter, HostedType type) {
        super(options, debug, jsLTools, methodGraphs, labeler, methodMetricsCollector, compiledMethodBytesCounter, type);
        this.isImportedClass = type.isAnnotationPresent(JS.Import.class);
        this.isSourceIncluded = type.isAnnotationPresent(JS.Code.Include.class) || type.isAnnotationPresent(JS.Code.class);
        this.isDirectSubclassOfImport = type.getSuperclass().isAnnotationPresent(JS.Import.class);
        this.isSubclassOfImport = ClassWithMirrorLowerer.isSubclassOfImport(type);
        this.externClassDescriptor = null;
    }

    public static boolean isFieldRepresentedInJavaScript(ResolvedJavaField field) {
        return !field.isStatic() && ClassWithMirrorLowerer.isJSObjectSubtype(OriginalClassProvider.getJavaClass((JavaType)field.getDeclaringClass()));
    }

    private boolean needExternDeclaration() {
        return this.isImportedClass && !this.isSourceIncluded;
    }

    private static boolean isSubclassOfImport(HostedType type) {
        return type != null && (type.isAnnotationPresent(JS.Import.class) || ClassWithMirrorLowerer.isSubclassOfImport((HostedType)type.getSuperclass()));
    }

    public static boolean isJSObjectSubtype(Class<?> cls) {
        return JSObject.class.isAssignableFrom(cls);
    }

    public static List<HostedField> getOwnFieldOnJSSide(HostedType type) {
        ArrayList<HostedField> fields = new ArrayList<HostedField>();
        for (HostedField instanceField : type.getInstanceFields(false)) {
            if (!ClassWithMirrorLowerer.isFieldRepresentedInJavaScript((ResolvedJavaField)instanceField)) continue;
            fields.add(instanceField);
        }
        return fields;
    }

    @Override
    public void lower(WebImageTypeControl typeControl) {
        if (this.needExternDeclaration()) {
            this.externClassDescriptor = this.codeGenTool.addExternJSClass(ClassWithMirrorLowerer.importedName(this.type));
        }
        super.lower(typeControl);
    }

    @Override
    protected void lowerPreamble(JSCodeGenTool tool) {
        JSCodeBuffer buffer = (JSCodeBuffer)tool.getCodeBuffer();
        buffer.emitNewLine();
        buffer.emitConstDeclPrefix(ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, this.type));
        HostedClass superclass = this.type.getSuperclass();
        if (this.isImportedClass) {
            String importedName = ClassWithMirrorLowerer.importedName(this.type);
            buffer.emitText(importedName);
            buffer.emitKeyword(JSKeyword.Semicolon);
            buffer.emitNewLine();
            if (this.needExternDeclaration()) {
                for (HostedField field : ClassWithMirrorLowerer.getOwnFieldOnJSSide(this.type)) {
                    this.externClassDescriptor.addProperty(field.getName());
                }
            }
        } else if (this.type.getJavaClass().equals(JSObject.class)) {
            ClassWithMirrorLowerer.suppressClassWarnings(buffer);
            buffer.emitText("class ");
            buffer.emitScopeBegin();
            buffer.emitText("constructor(...args) {}");
            buffer.emitNewLine();
            buffer.emitScopeEnd();
        } else {
            ClassWithMirrorLowerer.suppressClassWarnings(buffer);
            if (this.isDirectSubclassOfImport) {
                buffer.emitText("class ");
            } else {
                buffer.emitText("class extends " + ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, (HostedType)superclass));
                buffer.emitText(" ");
            }
            buffer.emitScopeBegin();
            this.genJavaScriptMirrorConstructor(tool, buffer);
            this.genBridgeMethods(buffer);
            buffer.emitScopeEnd();
        }
        buffer.emitNewLine();
        buffer.emitKeyword(JSKeyword.Semicolon);
        buffer.emitNewLine();
        buffer.emitNewLine();
        if (this.type.getAnnotation(JS.Export.class) != null) {
            this.genJavaScriptExportMirrorClassDefinition();
        }
    }

    private static void suppressClassWarnings(CodeBuffer buffer) {
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            buffer.emitText("/** @suppress {checkTypes|undefinedVars} */ ");
        }
    }

    private void genJavaScriptExportMirrorClassDefinition() {
        Class javaClass = this.type.getJavaClass();
        String className = javaClass.getName();
        String packageName = javaClass.getPackage().getName();
        if (packageName.length() > 0) {
            className = className.substring(packageName.length() + 1);
        }
        String hub = null;
        if (!((ClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).maybeInitializeAtBuildTime((ResolvedJavaType)this.type)) {
            hub = this.codeGenTool.getJSProviders().typeControl().requestHubName((ResolvedJavaType)this.type);
        }
        JSSnippet snippet = JSSnippets.instantiateExportMirrorClassDefinition(packageName, className, hub, ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, this.type));
        snippet.lower(this.codeGenTool);
    }

    private static String internalMirrorClassName(JSCodeGenTool codeGenTool, HostedType t) {
        return "$$" + codeGenTool.getJSProviders().typeControl().requestTypeName((ResolvedJavaType)t);
    }

    private void genJavaScriptMirrorConstructor(JSCodeGenTool tool, JSCodeBuffer buffer) {
        buffer.emitText("constructor(...args) ");
        buffer.emitScopeBegin();
        if (!this.isDirectSubclassOfImport) {
            buffer.emitText("super(SYM.skipJavaCtor);");
            buffer.emitNewLine();
        }
        for (HostedField field : ClassWithMirrorLowerer.getOwnFieldOnJSSide(this.type)) {
            tool.genResolvedVarDeclThisPrefix(field.getName());
            ClassWithMirrorLowerer.genDefaultValue(tool, buffer, field);
            tool.genResolvedVarDeclPostfix(null);
        }
        buffer.emitIfHeaderLeft();
        buffer.emitText("args[0] !== SYM.skipJavaCtor");
        buffer.emitIfHeaderRight();
        buffer.emitConstDeclPrefix("javaMirror");
        buffer.emitNew();
        tool.genTypeName((ResolvedJavaType)this.type);
        buffer.emitText("();");
        buffer.emitNewLine();
        buffer.emitText("conversion.setJavaScriptNative(javaMirror, this);");
        buffer.emitNewLine();
        buffer.emitText("this[SYM.javaNative] = javaMirror;");
        buffer.emitNewLine();
        buffer.emitConstDeclPrefix("handler");
        buffer.emitText("conversion.getOrCreateProxyHandler(");
        tool.genTypeName((ResolvedJavaType)this.type);
        buffer.emitText(");");
        buffer.emitNewLine();
        buffer.emitText("handler._getJavaConstructorMethod()(this, ...args);");
        buffer.emitNewLine();
        if (this.isSubclassOfImport) {
            buffer.emitConstDeclPrefix("importedThis");
            buffer.emitText("conversion.extractJavaScriptNative(javaMirror);");
            buffer.emitNewLine();
            buffer.emitText("Object.setPrototypeOf(importedThis, " + ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, this.type) + ");");
            buffer.emitNewLine();
            buffer.emitText("return importedThis;");
            buffer.emitNewLine();
        }
        buffer.emitScopeEnd();
        buffer.emitNewLine();
        buffer.emitScopeEnd();
        buffer.emitNewLine();
    }

    private void genBridgeMethods(CodeBuffer buffer) {
        HashSet<String> staticOverloads = new HashSet<String>();
        HashSet<String> instanceOverloads = new HashSet<String>();
        for (HostedMethod method : this.type.getDeclaredMethods(false)) {
            if (!method.isPublic() || method.isConstructor()) continue;
            if (method.isStatic()) {
                staticOverloads.add(method.getName());
                continue;
            }
            instanceOverloads.add(method.getName());
        }
        for (String name : instanceOverloads) {
            this.genBridgeMethod(buffer, name, false);
        }
        for (String name : staticOverloads) {
            this.genBridgeMethod(buffer, name, true);
        }
    }

    private void genBridgeMethod(CodeBuffer buffer, String name, boolean isStatic) {
        if (isStatic) {
            buffer.emitText("static ");
        }
        buffer.emitText(name);
        buffer.emitKeyword((Keyword)JSKeyword.LPAR);
        buffer.emitText("...args");
        buffer.emitKeyword((Keyword)JSKeyword.RPAR);
        buffer.emitWhiteSpace();
        buffer.emitScopeBegin();
        this.codeGenTool.genResolvedConstDeclPrefix("handler");
        buffer.emitText("conversion.getOrCreateProxyHandler(");
        this.codeGenTool.genTypeName((ResolvedJavaType)this.type);
        buffer.emitText(");");
        buffer.emitNewLine();
        buffer.emitText("return handler.");
        buffer.emitText(isStatic ? "_getStaticMethods()[" : "_getMethods()[");
        buffer.emitStringLiteral(name);
        buffer.emitText("].apply(");
        buffer.emitText(isStatic ? "null, args);" : "this, args);");
        buffer.emitNewLine();
        buffer.emitScopeEnd();
    }

    private static void genDefaultValue(JSCodeGenTool tool, CodeBuffer buffer, HostedField field) {
        switch (field.getJavaKind()) {
            case Boolean: {
                buffer.emitText("false");
                break;
            }
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Float: 
            case Long: 
            case Double: {
                buffer.emitText("0");
                break;
            }
            case Object: {
                tool.genNull();
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)field.getJavaKind().toString());
            }
        }
    }

    private static String importedName(HostedType type) {
        String importedName = ((JS.Import)type.getAnnotation(JS.Import.class)).value();
        return importedName.equals(UNSPECIFIED_IMPORTED_NAME_VALUE) ? ClassWithMirrorLowerer.computeImportedName(type) : importedName;
    }

    private static String computeImportedName(HostedType type) {
        String simpleName = type.getJavaClass().getSimpleName();
        if (type.getEnclosingType() == null) {
            return simpleName;
        }
        return ClassWithMirrorLowerer.computeImportedName(type.getEnclosingType()) + "." + simpleName;
    }

    @Override
    protected void genJavaMirrorJavaConstructorPreamble(StructuredGraph g) {
        ResolvedJavaMethod method = g.method();
        JSCodeBuffer codeBuffer = (JSCodeBuffer)this.codeGenTool.getCodeBuffer();
        String thisName = JSCodeBuffer.getParamName(0);
        codeBuffer.emitConstDeclPrefix("initialJavaScriptMirror");
        codeBuffer.emitText("conversion.extractJavaScriptNative(" + thisName + ");");
        codeBuffer.emitNewLine();
        if (this.isImportedClass) {
            codeBuffer.emitConstDeclPrefix("importedMirror");
            codeBuffer.emitText("new (" + ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, this.type) + ")(");
            Signature signature = method.getSignature();
            ResolvedJavaMethod.Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    codeBuffer.emitKeyword(JSKeyword.COMMA);
                }
                String boxedParam = this.boxedParameter((HostedType)signature.getParameterType(i, null).resolve(null), i);
                codeBuffer.emitText("conversion.javaToJavaScript(" + boxedParam + ")");
            }
            codeBuffer.emitText(");");
            codeBuffer.emitNewLine();
            codeBuffer.emitIfHeaderLeft();
            codeBuffer.emitText("initialJavaScriptMirror === null");
            codeBuffer.emitIfHeaderRight();
            codeBuffer.emitElse();
            codeBuffer.emitText("conversion.copyOwnFields(initialJavaScriptMirror, importedMirror);");
            codeBuffer.emitNewLine();
            codeBuffer.emitText("Object.setPrototypeOf(importedMirror, Object.getPrototypeOf(initialJavaScriptMirror));");
            codeBuffer.emitNewLine();
            codeBuffer.emitScopeEnd();
            codeBuffer.emitNewLine();
            codeBuffer.emitText("conversion.setJavaScriptNative(" + thisName + ", importedMirror);");
            codeBuffer.emitNewLine();
            codeBuffer.emitText("conversion.extractJavaScriptNative(" + thisName + ")[SYM.javaNative] = " + thisName + ";");
            codeBuffer.emitNewLine();
        } else {
            codeBuffer.emitIfHeaderLeft();
            codeBuffer.emitText("initialJavaScriptMirror === null");
            codeBuffer.emitIfHeaderRight();
            codeBuffer.emitText("conversion.setJavaScriptNative(" + thisName + ", new (" + ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, this.type) + ")(SYM.skipJavaCtor));");
            codeBuffer.emitNewLine();
            codeBuffer.emitText("conversion.extractJavaScriptNative(" + thisName + ")[SYM.javaNative] = " + thisName + ";");
            codeBuffer.emitNewLine();
            codeBuffer.emitScopeEnd();
            codeBuffer.emitNewLine();
        }
    }

    private String boxedParameter(HostedType t, int i) {
        String p = "p" + (i + 1);
        if (t.isPrimitive()) {
            String hub = this.codeGenTool.getJSProviders().typeControl().requestHubName((ResolvedJavaType)t);
            return hub + "[" + RuntimeConstants.RUNTIME_SYMBOL + ".box](" + p + ")";
        }
        return p;
    }

    @Override
    protected void lowerClassEnd() {
        super.lowerClassEnd();
        JSCodeBuffer buffer = (JSCodeBuffer)this.codeGenTool.getCodeBuffer();
        if (this.isImportedClass) {
            buffer.emitScopeBegin();
            buffer.emitLetDeclPrefix("facades");
            buffer.emitText("runtime.ensureFacadeSetFor(" + ClassWithMirrorLowerer.internalMirrorClassName(this.codeGenTool, this.type) + ");");
            buffer.emitNewLine();
            buffer.emitText("facades.add(");
            buffer.emitText(this.codeGenTool.getJSProviders().typeControl().requestTypeName((ResolvedJavaType)this.type));
            buffer.emitText(");");
            buffer.emitNewLine();
            buffer.emitScopeEnd();
            buffer.emitNewLine();
            buffer.emitNewLine();
        }
    }
}

