/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.oop;

import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.hosted.webimage.codegen.irwalk.WebImageJSIRWalker;
import com.oracle.svm.hosted.webimage.codegen.long64.Long64Lowerer;
import com.oracle.svm.hosted.webimage.codegen.oop.ClassWithMirrorLowerer;
import com.oracle.svm.hosted.webimage.codegen.type.ClassMetadataLowerer;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.AnnotationUtil;
import com.oracle.svm.hosted.webimage.util.metrics.CodeSizeCollector;
import com.oracle.svm.hosted.webimage.util.metrics.MethodMetricsCollector;
import com.oracle.svm.webimage.Labeler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.CodeBuffer;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.hightiercodegen.reconstruction.ScheduleWithReconstructionResult;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.webimage.api.JSResource;

public class ClassLowerer {
    public static final String HUB_PROP_NAME = "hub";
    private static final List<Function<ResolvedJavaType, String[]>> resourceProviders = new ArrayList<Function<ResolvedJavaType, String[]>>();
    private final OptionValues options;
    private final DebugContext debug;
    protected final JSCodeGenTool codeGenTool;
    private final CodeBuffer codeBuffer;
    private final Map<HostedMethod, StructuredGraph> methodGraphs;
    private final Labeler labeler;
    private final MethodMetricsCollector methodMetricsCollector;
    private final Consumer<Integer> compiledMethodBytesCounter;
    protected final HostedType type;
    private static final Signature NEW_INSTANCE_SIG = new Signature(){

        public JavaType getReturnType(ResolvedJavaType accessingClass) {
            return null;
        }

        public JavaKind getReturnKind() {
            return JavaKind.Void;
        }

        public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
            return null;
        }

        public JavaKind getParameterKind(int index) {
            return JavaKind.Void;
        }

        public int getParameterCount(boolean receiver) {
            return 0;
        }
    };

    public ClassLowerer(OptionValues options, DebugContext debug, JSCodeGenTool codeGenTool, Map<HostedMethod, StructuredGraph> methodGraphs, Labeler labeler, MethodMetricsCollector methodMetricsCollector, Consumer<Integer> compiledMethodBytesCounter, HostedType type) {
        this.options = options;
        this.debug = debug;
        this.codeGenTool = codeGenTool;
        this.codeBuffer = codeGenTool.getCodeBuffer();
        this.methodGraphs = methodGraphs;
        this.labeler = labeler;
        this.methodMetricsCollector = methodMetricsCollector;
        this.compiledMethodBytesCounter = compiledMethodBytesCounter;
        this.type = type;
    }

    protected void lowerPreamble(JSCodeGenTool tool) {
    }

    private void lowerClassHeader() {
        HostedClass superClass = this.type.getSuperclass();
        CodeBuffer masm = this.codeGenTool.getCodeBuffer();
        this.codeGenTool.genClassHeader((ResolvedJavaType)this.type);
        this.codeBuffer.emitMethodHeader(null, "constructor", NEW_INSTANCE_SIG, new ArrayList());
        if (superClass != null) {
            masm.emitNewLine();
            masm.emitText("super()");
            this.codeGenTool.genResolvedVarDeclPostfix(null);
        }
        for (HostedField field : this.type.getInstanceFields(false)) {
            if (ClassWithMirrorLowerer.isFieldRepresentedInJavaScript((ResolvedJavaField)field)) continue;
            ClassLowerer.genFieldInitialization(this.codeGenTool, masm, field);
        }
        if (this.type instanceof HostedInstanceClass) {
            this.codeGenTool.genComment("Generated Hash Code Field");
            this.codeGenTool.genResolvedVarDeclThisPrefix("__hc");
            masm.emitIntLiteral(0);
            this.codeGenTool.genResolvedVarDeclPostfix(null);
        }
        masm.emitFunctionEnd();
    }

    private static void genFieldInitialization(JSCodeGenTool jsLTools, CodeBuffer masm, HostedField field) {
        String fieldName = jsLTools.getJSProviders().typeControl().requestFieldName((ResolvedJavaField)field);
        HostedType fieldType = field.getType();
        JavaKind fieldKind = fieldType.getJavaKind();
        jsLTools.genComment(String.valueOf(field) + " type:" + String.valueOf(fieldType));
        if (((Boolean)WebImageOptions.ClosureCompiler.getValue()).booleanValue()) {
            String typeAnnotation = jsLTools.getClosureCompilerAnnotation((ResolvedJavaType)fieldType, true);
            masm.emitText("/** @type {" + typeAnnotation + "} */");
            masm.emitWhiteSpace();
        }
        jsLTools.genResolvedVarDeclThisPrefix(fieldName);
        switch (fieldKind) {
            case Boolean: 
            case Byte: 
            case Int: 
            case Short: 
            case Char: 
            case Double: 
            case Float: {
                masm.emitText("0");
                break;
            }
            case Long: {
                Long64Lowerer.lowerFromConstant((Constant)JavaConstant.forLong((long)0L), jsLTools);
                break;
            }
            case Object: {
                jsLTools.genNull();
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)fieldKind.toString());
            }
        }
        jsLTools.genResolvedVarDeclPostfix(null);
    }

    protected void lowerClassEnd() {
        this.codeGenTool.genClassEnd();
    }

    public void lower(WebImageTypeControl typeControl) {
        ClassLowerer.lowerJSResources(this.type, this.codeGenTool);
        try (Object collector = new CodeSizeCollector(ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE, () -> ((CodeBuffer)this.codeBuffer).codeSize());){
            this.lowerPreamble(this.codeGenTool);
            this.lowerClassHeader();
            String hubnameObjectName = this.codeGenTool.getJSProviders().typeControl().requestHubName((ResolvedJavaType)this.type);
            if (!this.type.isArray()) {
                CodeBuffer masm = this.codeGenTool.getCodeBuffer();
                masm.emitNewLine();
                masm.emitText("get hub() ");
                masm.emitScopeBegin();
                masm.emitNewLine();
                this.codeGenTool.genReturn(hubnameObjectName);
                this.codeGenTool.genScopeEnd();
            }
        }
        for (HostedMethod m : this.type.getAllDeclaredMethods()) {
            StructuredGraph graph = this.methodGraphs.get(m);
            if (graph == null) continue;
            try (DebugContext.Scope s = this.debug.scope((Object)"Compiling", (Object)graph, (Object)m);
                 MethodMetricsCollector.Collector c = this.methodMetricsCollector.collect(m);){
                LoggerContext.counter(MethodMetricKeys.NUM_SPLITS).add(graph.getNodes().filter(ControlSplitNode.class).count());
                typeControl.setDefaultReason(m);
                this.lowerMethod(m);
                typeControl.resetDefaultReason();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw JVMCIError.shouldNotReachHere((Throwable)t);
            }
            this.compiledMethodBytesCounter.accept(m.getCodeSize());
        }
        collector = new CodeSizeCollector(ImageBreakdownMetricKeys.TYPE_DECLARATIONS_SIZE, () -> ((CodeBuffer)this.codeBuffer).codeSize());
        try {
            this.lowerClassEnd();
            ClassMetadataLowerer.lowerClassMetadata(this.type, this.codeGenTool, this.methodGraphs);
        }
        finally {
            ((CodeSizeCollector)collector).close();
        }
    }

    public static void addResourceProvider(Function<ResolvedJavaType, String[]> resourceProvider) {
        resourceProviders.add(resourceProvider);
    }

    private static void lowerJSResources(HostedType type, JSCodeGenTool loweringTool) {
        List<JSResource> requiredJSResources = AnnotationUtil.getDeclaredAnnotationsByType((AnnotatedElement)type, JSResource.class, JSResource.Group.class, JSResource.Group::value);
        assert (requiredJSResources.size() != 0 || !type.isAnnotationPresent(JSResource.Group.class)) : "Repeated annotation not detected by getDeclaredAnnotationsByType";
        ArrayList<String> resourceNames = new ArrayList<String>(requiredJSResources.size());
        requiredJSResources.stream().map(JSResource::value).forEachOrdered(resourceNames::add);
        for (Function<ResolvedJavaType, String[]> resourceProvider : resourceProviders) {
            String[] resources = resourceProvider.apply((ResolvedJavaType)type);
            resourceNames.addAll(List.of(resources));
        }
        CodeBuffer masm = loweringTool.getCodeBuffer();
        if (!resourceNames.isEmpty()) {
            Class clazz = type.getJavaClass();
            masm.emitNewLine();
            String initFun = loweringTool.getJSProviders().typeControl().requestTypeName((ResolvedJavaType)type);
            masm.emitText("runtime.jsResourceInits." + initFun + " = () => {");
            masm.emitNewLine();
            for (String resName : resourceNames) {
                loweringTool.genComment(resName);
                try {
                    InputStream is = clazz.getResourceAsStream(resName);
                    try {
                        if (is == null) {
                            throw new FileNotFoundException(resName);
                        }
                        masm.emitText("(0,eval)(");
                        masm.emitNewLine();
                        masm.emitEscapedStringLiteral((Reader)new InputStreamReader(is));
                        masm.emitNewLine();
                        masm.emitText(");");
                        masm.emitNewLine();
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            masm.emitText("}");
            masm.emitNewLine();
            masm.emitText("runtime.jsResourceInits." + initFun + "();");
            masm.emitNewLine();
        }
    }

    private void lowerMethod(HostedMethod hMethod) {
        StructuredGraph g = this.methodGraphs.get(hMethod);
        this.codeGenTool.prepareForMethod(g);
        try (Labeler.Injection injection = this.labeler.injectMethodLabel(this.codeBuffer, hMethod);){
            this.lower(g);
        }
        LoggerContext.counter(UniverseMetricKeys.EMITTED_METHODS).increment();
    }

    private void lower(StructuredGraph g) {
        assert (g != null);
        ReconstructionData reconstructionData = ((ScheduleWithReconstructionResult)g.getLastSchedule()).reconstructionData();
        BlockMap blockToNodeMap = g.getLastSchedule().getBlockToNodesMap();
        ControlFlowGraph cfg = g.getLastSchedule().getCFG();
        HostedMethod method = (HostedMethod)g.method();
        if (method.isClassInitializer() && method.getDeclaringClass().isInitialized()) {
            return;
        }
        this.codeGenTool.genMethodHeader(g, (ResolvedJavaMethod)method, ClassLowerer.getParameters(g));
        this.codeGenTool.genComment(reconstructionData.toString(), WebImageOptions.CommentVerbosity.VERBOSE);
        if (g.method().isConstructor()) {
            this.genJavaMirrorJavaConstructorPreamble(g);
        }
        new WebImageJSIRWalker(this.codeGenTool, cfg, (BlockMap<List<Node>>)blockToNodeMap, (NodeMap<HIRBlock>)cfg.getNodeToBlock(), reconstructionData).lowerFunction(g.getDebug());
        this.codeGenTool.genFunctionEnd();
    }

    protected void genJavaMirrorJavaConstructorPreamble(StructuredGraph g) {
    }

    private static List<ParameterNode> getParameters(StructuredGraph graph) {
        ArrayList<ParameterNode> params = new ArrayList<ParameterNode>();
        for (ParameterNode n : graph.getNodes(ParameterNode.TYPE)) {
            params.add(n);
        }
        return params;
    }
}

