/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.node;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(allowedUsageTypes={InputType.Condition}, size=NodeSize.SIZE_1, cycles=NodeCycles.CYCLES_1)
public class CompoundConditionNode
extends LogicNode
implements Canonicalizable.BinaryCommutative<LogicNode> {
    public static final NodeClass<CompoundConditionNode> TYPE = NodeClass.create(CompoundConditionNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode x;
    @Node.Input(value=InputType.Condition)
    LogicNode y;
    protected final CompoundOp op;

    public CompoundConditionNode(LogicNode x, LogicNode y, CompoundOp op) {
        super(TYPE);
        this.x = x;
        this.y = y;
        this.op = op;
    }

    public LogicNode getX() {
        return this.x;
    }

    public LogicNode getY() {
        return this.y;
    }

    public CompoundOp getOp() {
        return this.op;
    }

    public Node maybeCommuteInputs() {
        if (!this.y.isConstant() && (this.x.isConstant() || this.x.getId() > this.y.getId())) {
            LogicNode duplicate;
            LogicNode tmp = this.x;
            this.x = this.y;
            this.y = tmp;
            if (this.graph() != null && (duplicate = (LogicNode)this.graph().findDuplicate((Node)this)) != null) {
                return duplicate;
            }
        }
        return this;
    }

    public Node canonical(CanonicalizerTool tool, LogicNode forX, LogicNode forY) {
        return switch (this.getOp().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (forX.isTautology()) {
                    yield forY;
                }
                if (forY.isTautology()) {
                    yield forX;
                }
                if (forX.isContradiction() || forY.isContradiction()) {
                    yield LogicConstantNode.contradiction();
                }
                yield this;
            }
            case 1 -> forX.isContradiction() ? forY : (forY.isContradiction() ? forX : (forX.isTautology() || forY.isTautology() ? LogicConstantNode.tautology() : this));
        };
    }

    public static enum CompoundOp {
        XaaY,
        XooY;

    }
}

