/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.long64;

import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.js.JSStaticFieldDefinition;
import com.oracle.svm.hosted.webimage.js.JSStaticMethodDefinition;
import com.oracle.svm.webimage.longemulation.Long64;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.nodes.ArithmeticOperation;
import jdk.graal.compiler.nodes.BinaryOpLogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;

public class Long64Lowerer {
    public static final long JS_MAX_EXACT_INT53 = 0x1FFFFFFFFFFFFFL;
    public static final long JS_MIN_EXACT_INT53 = -9007199254740991L;
    private static final EconomicMap<Method, JSStaticMethodDefinition> staticJSMethodCache = EconomicMap.create();
    private static final EconomicMap<Field, JSStaticFieldDefinition> staticJSFieldCache = EconomicMap.create();

    public static JSStaticMethodDefinition getJSStaticMethodDefinition(Method method, JSCodeGenTool jsLTools) {
        if (staticJSMethodCache.containsKey((Object)method)) {
            return (JSStaticMethodDefinition)staticJSMethodCache.get((Object)method);
        }
        ResolvedJavaMethod m = jsLTools.getProviders().getMetaAccess().lookupJavaMethod((Executable)method);
        JSStaticMethodDefinition jsStaticMethodDefinition = new JSStaticMethodDefinition(m);
        staticJSMethodCache.put((Object)method, (Object)jsStaticMethodDefinition);
        return jsStaticMethodDefinition;
    }

    public static JSStaticFieldDefinition getJSStaticFieldDefinition(Field field, JSCodeGenTool jsLTools) {
        if (staticJSFieldCache.containsKey((Object)field)) {
            return (JSStaticFieldDefinition)staticJSFieldCache.get((Object)field);
        }
        ResolvedJavaField f = jsLTools.getProviders().getMetaAccess().lookupJavaField(field);
        JSStaticFieldDefinition jsStaticFieldDefinition = new JSStaticFieldDefinition(f);
        staticJSFieldCache.put((Object)field, (Object)jsStaticFieldDefinition);
        return jsStaticFieldDefinition;
    }

    public static void lowerFromConstant(Constant c, JSCodeGenTool jsLTools) {
        assert (c instanceof PrimitiveConstant) : c;
        long longVal = ((PrimitiveConstant)c).asLong();
        if (longVal == 0L) {
            try {
                Field f = Long64.class.getField("LongZero");
                JSStaticFieldDefinition constantDefinition = Long64Lowerer.getJSStaticFieldDefinition(f, jsLTools);
                constantDefinition.emitAccess(jsLTools);
            }
            catch (NoSuchFieldException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
        }
        if (Integer.MIN_VALUE <= longVal && longVal <= Integer.MAX_VALUE) {
            Method m;
            try {
                m = Long64.class.getMethod("fromInt", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
            Long64Lowerer.getJSStaticMethodDefinition(m, jsLTools).emitCall((CodeGenTool)jsLTools, new IEmitter[]{Emitter.of((Integer)((int)longVal))});
        } else {
            Method m;
            int low = (int)longVal;
            int high = (int)(longVal >> 32);
            try {
                m = Long64.class.getMethod("fromTwoInt", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
            Long64Lowerer.getJSStaticMethodDefinition(m, jsLTools).emitCall((CodeGenTool)jsLTools, new IEmitter[]{Emitter.of((Integer)low), Emitter.of((Integer)high)});
        }
    }

    public static void lowerSubstitutedDeclaration(JSCodeGenTool jsLTools, long val) {
        Long64Lowerer.lowerFromConstant((Constant)JavaConstant.forLong((long)val), jsLTools);
    }

    private static boolean fromNum(ShiftNode<?> n) {
        ValueNode y = n.getY();
        return y.getStackKind() != JavaKind.Long;
    }

    public static Method methodForArithmeticOperation(ValueNode n) {
        Method method;
        block31: {
            ArithmeticOpTable.Op op;
            ArithmeticOpTable arithmeticOpTable = IntegerStamp.OPS;
            if (n instanceof ArithmeticOperation) {
                op = ((ArithmeticOperation)n).getArithmeticOp();
            } else {
                assert (n instanceof IntegerDivRemNode) : n;
                switch (((IntegerDivRemNode)n).getOp()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DIV: {
                        ArithmeticOpTable.BinaryOp binaryOp = IntegerStamp.OPS.getDiv();
                        break;
                    }
                    case REM: {
                        ArithmeticOpTable.BinaryOp binaryOp = op = IntegerStamp.OPS.getRem();
                    }
                }
            }
            assert (op != null);
            boolean fromNum = false;
            if (n instanceof ShiftNode) {
                fromNum = Long64Lowerer.fromNum((ShiftNode)n);
            }
            Class<Long64> long64Class = Long64.class;
            try {
                if (op.equals((Object)arithmeticOpTable.getNeg())) {
                    method = long64Class.getMethod("negate", Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getAdd())) {
                    method = long64Class.getMethod("add", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getSub())) {
                    method = long64Class.getMethod("sub", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getMul())) {
                    method = long64Class.getMethod("mul", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getMulHigh()) || op.equals((Object)arithmeticOpTable.getUMulHigh())) {
                    throw GraalError.unimplemented((String)("Unsupported operation mul high in long emulation " + String.valueOf(n)));
                }
                if (op.equals((Object)arithmeticOpTable.getDiv())) {
                    method = long64Class.getMethod("div", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getRem())) {
                    method = long64Class.getMethod("mod", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getNot())) {
                    method = long64Class.getMethod("not", Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getAnd())) {
                    method = long64Class.getMethod("and", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getOr())) {
                    method = long64Class.getMethod("or", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getXor())) {
                    method = long64Class.getMethod("xor", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getShl())) {
                    method = fromNum ? long64Class.getMethod("slFromNum", Long64.class, Integer.TYPE) : long64Class.getMethod("sl", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getShr())) {
                    method = fromNum ? long64Class.getMethod("srFromNum", Long64.class, Integer.TYPE) : long64Class.getMethod("sr", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getUShr())) {
                    method = fromNum ? long64Class.getMethod("usrFromNum", Long64.class, Integer.TYPE) : long64Class.getMethod("usr", Long64.class, Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getAbs())) {
                    method = long64Class.getMethod("abs", Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getZeroExtend())) {
                    method = long64Class.getMethod("fromZeroExtend", Integer.TYPE);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getSignExtend())) {
                    method = long64Class.getMethod("fromInt", Integer.TYPE);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getNarrow())) {
                    method = long64Class.getMethod("lowBits", Long64.class);
                    break block31;
                }
                if (op.equals((Object)arithmeticOpTable.getFloatConvert(FloatConvert.L2D)) || op.equals((Object)arithmeticOpTable.getFloatConvert(FloatConvert.L2F))) {
                    method = long64Class.getMethod("toNumber", Long64.class);
                    break block31;
                }
                if (op.equals((Object)FloatStamp.OPS.getFloatConvert(FloatConvert.D2L)) || op.equals((Object)FloatStamp.OPS.getFloatConvert(FloatConvert.F2L))) {
                    method = long64Class.getMethod("fromDouble", Double.TYPE);
                    break block31;
                }
                throw GraalError.unimplemented((String)("There is no long emulation method in Java for " + String.valueOf(n) + " with the operation " + String.valueOf(op)));
            }
            catch (NoSuchMethodException e) {
                throw GraalError.shouldNotReachHere((Throwable)e);
            }
        }
        return method;
    }

    public static Method getBinaryLogicMethod(BinaryOpLogicNode n) {
        try {
            if (n instanceof CompareNode) {
                switch (((CompareNode)n).condition()) {
                    case EQ: {
                        return Long64.class.getMethod("equal", Long64.class, Long64.class);
                    }
                    case LT: {
                        return Long64.class.getMethod("lessThan", Long64.class, Long64.class);
                    }
                    case BT: {
                        return Long64.class.getMethod("belowThan", Long64.class, Long64.class);
                    }
                }
            } else if (n instanceof IntegerTestNode) {
                return Long64.class.getMethod("test", Long64.class, Long64.class);
            }
        }
        catch (NoSuchMethodException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
        throw GraalError.unimplemented((String)("unhandled long64 binary operation logic node" + String.valueOf(n)));
    }

    public static void genBinaryArithmeticOperation(ValueNode node, ValueNode lOp, ValueNode rOp, JSCodeGenTool jsLTools) {
        Long64Lowerer.genLong64MethodCall(Long64Lowerer.methodForArithmeticOperation(node), jsLTools, new IEmitter[]{Emitter.of((ValueNode)lOp), Emitter.of((ValueNode)rOp)});
    }

    public static void genUnaryArithmeticOperation(UnaryNode node, ValueNode value, JSCodeGenTool jsLTools) {
        Long64Lowerer.genUnaryArithmeticOperation(node, (IEmitter)Emitter.of((ValueNode)value), jsLTools);
    }

    public static void genUnaryArithmeticOperation(UnaryNode node, IEmitter value, JSCodeGenTool jsLTools) {
        Long64Lowerer.genLong64MethodCall(Long64Lowerer.methodForArithmeticOperation((ValueNode)node), jsLTools, value);
    }

    public static void genBinaryLogicNode(BinaryOpLogicNode node, ValueNode lOp, ValueNode rOp, JSCodeGenTool jsLTools) {
        Long64Lowerer.genLong64MethodCall(Long64Lowerer.getBinaryLogicMethod(node), jsLTools, new IEmitter[]{Emitter.of((ValueNode)lOp), Emitter.of((ValueNode)rOp)});
    }

    private static void genLong64MethodCall(Method long64method, JSCodeGenTool jsLTools, IEmitter ... args) {
        JSStaticMethodDefinition long64JSMethod = Long64Lowerer.getJSStaticMethodDefinition(long64method, jsLTools);
        long64JSMethod.emitCall((CodeGenTool)jsLTools, args);
    }
}

