/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.irwalk;

import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.StackifierMetricKeys;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import java.util.List;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.irwalk.StackifierIRWalker;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;

public final class WebImageJSIRWalker
extends StackifierIRWalker {
    public WebImageJSIRWalker(JSCodeGenTool jsLTools, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlock, ReconstructionData reconstructionData) {
        super((CodeGenTool)jsLTools, cfg, blockToNodeMap, nodeToBlock, reconstructionData);
    }

    protected void lower(DebugContext debugContext) {
        LoggerContext.counter(StackifierMetricKeys.NUM_ELSE_SCOPES).add(this.stackifierData.getNrElseScopes());
        LoggerContext.counter(StackifierMetricKeys.NUM_THEN_SCOPES).add(this.stackifierData.getNrThenScopes());
        LoggerContext.counter(StackifierMetricKeys.NUM_LOOP_SCOPES).add(this.stackifierData.getNrLoopScopes());
        LoggerContext.counter(StackifierMetricKeys.NUM_FORWARD_BLOCKS).add(this.stackifierData.getNrOfLabeledBlocks());
        LoggerContext.counter(MethodMetricKeys.NUM_BLOCKS).add(this.stackifierData.getBlocks().length);
        super.lower(debugContext);
    }

    protected boolean lowerNode(Node n) {
        boolean lowererd = super.lowerNode(n);
        if (!lowererd && WebImageOptions.genJSComments()) {
            String info = this.codeGenTool.nodeLowerer().nodeDebugInfo(n);
            this.codeGenTool.genComment("ignored " + info);
        }
        return lowererd;
    }
}

