/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.heap;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.config.DynamicHubLayout;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.PatchedWordConstant;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.WebImageTypeControl;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import com.oracle.svm.webimage.object.ObjectInspector;
import com.oracle.svm.webimage.type.TypeControl;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.WordBase;

public class WebImageObjectInspector
extends ObjectInspector {
    private final WebImageJSProviders providers;
    private final TypeControl typeControl;
    private final ConstantReflectionProvider constantReflection;

    public WebImageObjectInspector(WebImageJSProviders providers) {
        this.providers = providers;
        this.typeControl = providers.typeControl();
        this.constantReflection = providers.getConstantReflection();
    }

    @Override
    public ObjectInspector.ObjectDefinition inspectObject(JavaConstant c, Object reason, ConstantIdentityMapping identityMapping) {
        ObjectInspector.ObjectDefinition odef;
        if (c.isNull()) {
            return NULL;
        }
        if (c instanceof PrimitiveConstant) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)c;
            return WebImageObjectInspector.buildValueType(primitiveConstant);
        }
        if (identityMapping.hasMappingForObject(c)) {
            ObjectInspector.ObjectDefinition def = identityMapping.getDefByObject(c);
            def.addReason(reason);
            return def;
        }
        assert (!this.isFrozen()) : "Object inspector already frozen";
        HostedType type = (HostedType)this.providers.getMetaAccess().lookupJavaType(c);
        if (type.isArray()) {
            odef = new ObjectInspector.ArrayType<ObjectInspector.ObjectDefinition>(c, type.getComponentType(), reason);
        } else if (type.getJavaClass() == String.class) {
            String strValue = (String)this.providers.getSnippetReflection().asObject(String.class, c);
            odef = new ObjectInspector.StringType(c, strValue, reason);
        } else {
            ObjectInspector.ClassFieldList fields = this.buildObjectTypeFieldList(type, identityMapping);
            odef = new ObjectInspector.ObjectType(c, type, fields, reason);
        }
        identityMapping.putObjectDef(odef);
        if (odef instanceof ObjectInspector.ArrayType) {
            this.buildArrayType((ObjectInspector.ArrayType<ObjectInspector.ObjectDefinition>)odef, c, identityMapping);
        } else if (odef instanceof ObjectInspector.StringType) {
            ObjectInspector.StringType stringType = (ObjectInspector.StringType)odef;
            WebImageObjectInspector.buildStringType(stringType, identityMapping);
        } else {
            this.buildObjectType((ObjectInspector.ObjectType)odef, c, identityMapping);
        }
        return odef;
    }

    protected static ObjectInspector.ValueType buildValueType(PrimitiveConstant c) {
        JavaKind kind = c.getJavaKind();
        if (kind == JavaKind.Boolean) {
            return c.asBoolean() ? TRUE : FALSE;
        }
        if (c.isDefaultForKind()) {
            return switch (kind) {
                case JavaKind.Byte -> ZERO_BYTE;
                case JavaKind.Short -> ZERO_SHORT;
                case JavaKind.Char -> ZERO_CHAR;
                case JavaKind.Int -> ZERO_INT;
                case JavaKind.Float -> ZERO_FLOAT;
                case JavaKind.Long -> ZERO_LONG;
                case JavaKind.Double -> ZERO_DOUBLE;
                default -> throw GraalError.shouldNotReachHere((String)c.toString());
            };
        }
        return ObjectInspector.ValueType.forConstant(c);
    }

    protected ObjectInspector.ClassFieldList buildObjectTypeFieldList(HostedType type, ConstantIdentityMapping identityMapping) {
        if (identityMapping.hasListForType(type)) {
            return identityMapping.getListForType(type);
        }
        ObjectInspector.ClassFieldList fields = new ObjectInspector.ClassFieldList();
        fields.type = type;
        fields.fields = new ArrayList<HostedField>();
        this.typeControl.requestTypeName((ResolvedJavaType)type);
        for (HostedField f : type.getInstanceFields(true)) {
            if (HybridLayout.isHybridField((HostedField)f) || f.equals(DynamicHubLayout.singleton().vTableField) || !f.isRead()) continue;
            if (WebImageObjectInspector.isReferenceType(f)) {
                fields.fields.add(f);
                continue;
            }
            if (WebImageObjectInspector.isPrimitiveType(f)) {
                assert (f.isAccessed()) : f;
                fields.fields.add(f);
                continue;
            }
            if (!WebImageObjectInspector.isWordType(f)) continue;
            fields.fields.add(f);
        }
        identityMapping.putFieldList(fields);
        return fields;
    }

    private static boolean isWordType(HostedField f) {
        return !f.getType().isPrimitive() && f.getType().getStorageKind().isPrimitive() && (f.isAccessed() || f.isWritten());
    }

    private static boolean isPrimitiveType(HostedField f) {
        return f.getType().isPrimitive();
    }

    private static boolean isReferenceType(HostedField f) {
        return f.getType().getStorageKind() == JavaKind.Object && (f.isAccessed() || f.isWritten());
    }

    private void buildObjectType(ObjectInspector.ObjectType out, JavaConstant c, ConstantIdentityMapping identityMapping) {
        ObjectInspector.ClassFieldList fields = out.fields;
        ArrayList<ObjectInspector.ObjectDefinition> members = new ArrayList<ObjectInspector.ObjectDefinition>();
        HostedUniverse hUniverse = ((WebImageTypeControl)this.typeControl).getHUniverse();
        for (HostedField f : fields.fields) {
            PatchedWordConstant pwc;
            WordBase wordBase;
            JavaConstant fieldValue;
            if (f.getJavaKind().isObject() && f.getType().getStorageKind().isObject()) {
                if (!f.isValueAvailable()) {
                    members.add(NULL);
                    continue;
                }
                fieldValue = this.constantReflection.readFieldValue((ResolvedJavaField)f, c);
                members.add(this.inspectObject(fieldValue, out, identityMapping));
                continue;
            }
            if (!f.getType().isPrimitive() && (!f.getJavaKind().isObject() || !f.getType().getStorageKind().isPrimitive())) continue;
            fieldValue = this.constantReflection.readFieldValue((ResolvedJavaField)f, c);
            if (fieldValue instanceof PatchedWordConstant && (wordBase = (pwc = (PatchedWordConstant)fieldValue).getWord()) instanceof MethodPointer) {
                MethodPointer pointer = (MethodPointer)wordBase;
                AnalysisMethod method = (AnalysisMethod)pointer.getMethod();
                HostedMethod hostedMethod = hUniverse.lookup((JavaMethod)method);
                this.typeControl.requestTypeName(hostedMethod.getDeclaringClass());
                int index = identityMapping.addMethodPointer((ResolvedJavaMethod)hostedMethod);
                members.add(new ObjectInspector.MethodPointerType((JavaConstant)pwc, (ResolvedJavaMethod)hostedMethod, index, f));
                continue;
            }
            if (fieldValue instanceof PrimitiveConstant) {
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)fieldValue;
                members.add(this.inspectObject((JavaConstant)primitiveConstant, out, identityMapping));
                continue;
            }
            throw GraalError.shouldNotReachHere((String)fieldValue.toString());
        }
        out.members = members;
        assert (members.size() == fields.fields.size()) : members.size() + " != " + fields.fields.size();
    }

    private static void buildStringType(ObjectInspector.StringType out, ConstantIdentityMapping identityMapping) {
        identityMapping.putString(out);
    }

    private void buildArrayType(ObjectInspector.ArrayType<ObjectInspector.ObjectDefinition> out, JavaConstant c, ConstantIdentityMapping identityMapping) {
        assert (c.isNonNull());
        ResolvedJavaType arrayType = this.providers.getMetaAccess().lookupJavaType(c);
        assert (arrayType.isArray()) : c;
        HostedType componentType = (HostedType)arrayType.getComponentType();
        this.typeControl.requestHubName((ResolvedJavaType)componentType.getArrayClass());
        int length = Objects.requireNonNull(this.constantReflection.readArrayLength(c));
        out.isAllEqual = length != 0;
        out.elements = new ArrayList(length);
        Consumer<ObjectInspector.ObjectDefinition> addElement = odef -> {
            out.elements.add(odef);
            if (out.isAllEqual && !odef.equals(out.elements.get(0))) {
                out.isAllEqual = false;
            }
        };
        if (componentType.isPrimitive()) {
            for (int i = 0; i < length; ++i) {
                JavaConstant valueConstant = this.constantReflection.readArrayElement(c, i);
                ObjectInspector.ObjectDefinition odef2 = this.inspectObject(valueConstant, out, identityMapping);
                addElement.accept(odef2);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                JavaConstant valueConstant = this.constantReflection.readArrayElement(c, i);
                if (valueConstant.isNull()) {
                    addElement.accept(NULL);
                    continue;
                }
                boolean continueInspection = false;
                Class tc = ((HostedType)this.providers.getMetaAccess().lookupJavaType(valueConstant)).getJavaClass();
                for (Class<?> interfaces : tc.getInterfaces()) {
                    if (!interfaces.equals(CFunctionPointer.class)) continue;
                    continueInspection = true;
                    break;
                }
                if (continueInspection) continue;
                addElement.accept(this.inspectObject(valueConstant, out, identityMapping));
            }
        }
    }
}

