/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.codegen.heap;

import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.JSCodeBuffer;
import com.oracle.svm.hosted.webimage.codegen.Array;
import com.oracle.svm.hosted.webimage.codegen.JSCodeGenTool;
import com.oracle.svm.hosted.webimage.codegen.Runtime;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSProviders;
import com.oracle.svm.hosted.webimage.codegen.wrappers.JSEmitter;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.util.metrics.BootHeapMetricsCollector;
import com.oracle.svm.hosted.webimage.util.metrics.CodeSizeCollector;
import com.oracle.svm.webimage.object.ConstantIdentityMapping;
import com.oracle.svm.webimage.object.ObjectInspector;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class JSBootImageHeapLowerer {
    public static final String OBJECT_INIT_FUN = "object_init";
    public static final String OBJECT_HASH_INIT_FUN = "object_init_hash";
    public static final String FIELD_LIST = "fieldLists";
    protected final ConstantIdentityMapping identityMapping;
    protected final JSCodeGenTool jsLTools;
    protected final JSCodeBuffer masm;
    protected final WebImageJSProviders providers;

    public JSBootImageHeapLowerer(WebImageJSProviders providers, JSCodeGenTool jsLTools, ConstantIdentityMapping identityMapping) {
        this.identityMapping = identityMapping;
        this.jsLTools = jsLTools;
        this.providers = providers;
        this.masm = (JSCodeBuffer)jsLTools.getCodeBuffer();
    }

    public void emitSetup() {
        this.collectMetrics();
        this.lowerFieldLists();
        this.masm.emitNewLine();
        this.masm.emitNewLine();
        for (ResolvedJavaMethod method : this.identityMapping.getMethodPointers()) {
            Runtime.ADD_TO_FUNTAB.emitCall((CodeGenTool)this.jsLTools, JSEmitter.ofMethodReference(method));
            this.masm.emitText(";");
            this.masm.emitNewLine();
        }
        this.masm.emitNewLine();
        this.masm.emitNewLine();
    }

    protected void collectMetrics() {
        BootHeapMetricsCollector metricsCollector = new BootHeapMetricsCollector(LoggerContext.currentContext().currentScope(), this.jsLTools.getJSProviders().typeControl());
        for (ConstantIdentityMapping.IdentityNode node : this.identityMapping.identityNodes()) {
            ObjectInspector.ObjectDefinition def = node.getDefinition();
            if (def instanceof ObjectInspector.ObjectType) {
                HostedInstanceClass resolvedType = (HostedInstanceClass)this.providers.getMetaAccess().lookupJavaType(def.getConstant());
                metricsCollector.constantObject(resolvedType);
                continue;
            }
            if (def instanceof ObjectInspector.ArrayType) {
                metricsCollector.constantArray((ObjectInspector.ArrayType)def);
                continue;
            }
            if (def instanceof ObjectInspector.ValueType) {
                ObjectInspector.ValueType valueType = (ObjectInspector.ValueType)def;
                metricsCollector.constantPrimitive(valueType);
                continue;
            }
            if (def instanceof ObjectInspector.StringType) {
                ObjectInspector.StringType stringType = (ObjectInspector.StringType)def;
                metricsCollector.constantString(stringType);
                continue;
            }
            if (def instanceof ObjectInspector.MethodPointerType) {
                ObjectInspector.MethodPointerType methodPointerType = (ObjectInspector.MethodPointerType)def;
                metricsCollector.constantMethodPointer(methodPointerType);
                continue;
            }
            JVMCIError.shouldNotReachHere((String)def.toString());
        }
    }

    public void lowerDeclarations() {
        for (ConstantIdentityMapping.IdentityNode node : this.identityMapping.identityNodes()) {
            if (!node.hasName()) continue;
            String name = node.getName();
            ObjectInspector.ObjectDefinition def = node.getDefinition();
            this.jsLTools.genResolvedVarDeclPrefix(name);
            if (def instanceof ObjectInspector.ObjectType) {
                this.emitObjectDeclaration((ObjectInspector.ObjectType)def);
                this.jsLTools.genResolvedVarDeclPostfix(null);
                continue;
            }
            if (def instanceof ObjectInspector.ArrayType) {
                this.emitArrayDeclaration((ObjectInspector.ArrayType)def);
                this.jsLTools.genResolvedVarDeclPostfix(null);
                continue;
            }
            if (def instanceof ObjectInspector.ValueType) continue;
            if (def instanceof ObjectInspector.StringType) {
                this.emitStringDeclaration((ObjectInspector.StringType)def);
                this.jsLTools.genResolvedVarDeclPostfix(null);
                continue;
            }
            JVMCIError.shouldNotReachHere();
        }
    }

    protected void emitObjectDeclaration(ObjectInspector.ObjectType otype) {
        JVMCIError.guarantee((boolean)otype.getConstant().isNonNull(), (String)"Object must not be null %s", (Object[])new Object[]{otype});
        this.jsLTools.genObjectCreate((IEmitter)Emitter.of((ResolvedJavaType)otype.type), new IEmitter[0]);
    }

    protected void emitArrayDeclaration(ObjectInspector.ArrayType<?> arrayType) {
        HostedType t = arrayType.componentType;
        Array.lowerArrayConstructor(t.getJavaKind(), arrayType.length(), this.jsLTools);
    }

    protected void emitStringDeclaration(ObjectInspector.StringType strType) {
        Runtime.TO_JAVA_STRING_LAZY.emitCall((CodeGenTool)this.jsLTools, new IEmitter[]{Emitter.stringLiteral((String)strType.stringVal)});
    }

    protected void lowerFieldLists() {
        Supplier<Stream> stream = () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.identityMapping.classFieldListIterator(), 16), false).sorted(Comparator.comparingInt(ObjectInspector.ClassFieldList::getId));
        Iterator it = stream.get().iterator();
        assert (this.masm.getScopeIndent() == 0) : this.masm.getScopeIndent();
        this.masm.emitNewLine();
        this.masm.emitText("const fieldLists = [");
        int lastFieldListId = 0;
        while (it.hasNext()) {
            ObjectInspector.ClassFieldList classFieldList = (ObjectInspector.ClassFieldList)it.next();
            this.masm.setScopeIndent(1);
            int fieldListId = classFieldList.getId();
            while (lastFieldListId < fieldListId) {
                this.masm.emitText(",");
                ++lastFieldListId;
            }
            this.masm.emitNewLine();
            this.jsLTools.genComment(fieldListId + ": " + classFieldList.type.toString());
            this.masm.emitText("[");
            this.masm.setScopeIndent(2);
            this.masm.emitNewLine();
            this.jsLTools.genTypeName((ResolvedJavaType)classFieldList.type);
            this.masm.emitText(",");
            for (HostedField f : classFieldList.fields) {
                this.masm.emitNewLine();
                this.masm.emitText("[\"");
                this.jsLTools.genFieldName((ResolvedJavaField)f);
                this.masm.emitText("\",");
                this.masm.emitIntLiteral(JSBootImageHeapLowerer.getKindNum(f));
                this.masm.emitText("]");
                this.masm.emitText(",");
            }
            this.masm.setScopeIndent(1);
            this.masm.emitNewLine();
            this.masm.emitText("]");
        }
        this.masm.setScopeIndent(0);
        this.masm.emitNewLine();
        this.masm.emitText("];");
    }

    public void lowerInitialization() {
        for (ConstantIdentityMapping.IdentityNode node : this.identityMapping.identityNodes()) {
            ObjectInspector.ObjectDefinition def = node.getDefinition();
            if (def instanceof ObjectInspector.StringType || def instanceof ObjectInspector.MethodPointerType) continue;
            if (def instanceof ObjectInspector.ValueType) {
                JVMCIError.shouldNotReachHere((String)"All value types should have already been resolved");
            }
            int hashCode = this.providers.getIdentityHashCodeProvider().identityHashCode(node.getDefinition().getConstant());
            if (def instanceof ObjectInspector.ObjectType) {
                CodeSizeCollector collector = CodeSizeCollector.trackObjectSize(() -> ((JSCodeGenTool)this.jsLTools).getCodeSize());
                try {
                    this.emitObjectInitializer(node, (ObjectInspector.ObjectType)def, hashCode);
                    continue;
                }
                finally {
                    if (collector != null) {
                        collector.close();
                    }
                    continue;
                }
            }
            if (def instanceof ObjectInspector.ArrayType) {
                ObjectInspector.ArrayType atype = (ObjectInspector.ArrayType)def;
                CodeSizeCollector collector = CodeSizeCollector.trackObjectSize(() -> ((JSCodeGenTool)this.jsLTools).getCodeSize());
                try {
                    this.emitArrayInitializer(node, atype, hashCode);
                    continue;
                }
                finally {
                    if (collector != null) {
                        collector.close();
                    }
                    continue;
                }
            }
            JVMCIError.shouldNotReachHere((String)("Invalid object definition: " + def.getClass().getName()));
        }
    }

    protected void emitHashInitializer(ConstantIdentityMapping.IdentityNode node, int hashCode) {
        if (hashCode != 0) {
            this.masm.emitNewLine();
            this.masm.emitText("object_init_hash(" + node.requestName() + ", ");
            this.masm.emitIntLiteral(hashCode);
            this.masm.emitText(");");
        }
    }

    protected void emitObjectInitializer(ConstantIdentityMapping.IdentityNode node, ObjectInspector.ObjectType odef, int hashCode) {
        if (odef.members.isEmpty()) {
            this.emitHashInitializer(node, hashCode);
            return;
        }
        this.masm.emitNewLine();
        ArrayList<JSEmitter> args = new ArrayList<JSEmitter>(odef.members.size() + 3);
        args.add(JSEmitter.of(node));
        args.add((JSEmitter)Emitter.of((Integer)odef.fields.getId()));
        args.add((JSEmitter)Emitter.of((Integer)hashCode));
        odef.members.forEach(oo -> args.add((JSEmitter)this.valueEmitter((ObjectInspector.ObjectDefinition)oo)));
        this.jsLTools.genFunctionCall(null, (IEmitter)Emitter.of((String)OBJECT_INIT_FUN), args.toArray(new IEmitter[0]));
        this.masm.emitInsEnd();
    }

    protected static int[] packIntegerValues(ObjectInspector.ArrayType<ObjectInspector.ObjectDefinition> atype, int bits, ToIntFunction<ObjectInspector.ValueType> getter) {
        int len = atype.length();
        assert (32 % bits == 0) : bits;
        int perInt = 32 / bits;
        int mask = bits == 32 ? -1 : (1 << bits) - 1;
        int[] ints = new int[(len + (perInt - 1)) / perInt];
        for (int i = 0; i < ints.length; ++i) {
            int idx;
            int compound = 0;
            for (int j = 0; j < perInt && (idx = i * perInt + j) < atype.length(); ++j) {
                ObjectInspector.ValueType val = (ObjectInspector.ValueType)atype.elements.get(idx);
                assert (val.kind == atype.componentType.getJavaKind()) : String.valueOf(val.kind) + " != " + String.valueOf(atype.componentType.getJavaKind());
                int component = getter.applyAsInt(val) & mask;
                compound |= component << j * bits;
            }
            ints[i] = compound;
        }
        return ints;
    }

    protected void emitArrayInitializer(ConstantIdentityMapping.IdentityNode node, ObjectInspector.ArrayType<ObjectInspector.ObjectDefinition> atype, int hashCode) {
        String arrayName = node.requestName();
        HostedType componentType = atype.componentType;
        HostedArrayClass ac = componentType.getArrayClass();
        assert (ac != null);
        assert (ac.isArray()) : ac;
        String hubVarName = this.jsLTools.getJSProviders().typeControl().requestHubName((ResolvedJavaType)ac);
        JavaKind kind = componentType.getJavaKind();
        if (atype.isAllEqual) {
            this.masm.emitNewLine();
            ObjectInspector.ObjectDefinition firstEl = (ObjectInspector.ObjectDefinition)atype.elements.get(0);
            if (kind == JavaKind.Long) {
                Runtime.ArrayInitFunWithHubBigInt64.emitCall((CodeGenTool)this.jsLTools, new IEmitter[]{JSEmitter.of(node), this.valueEmitter(firstEl), Emitter.of((String)hubVarName), Emitter.of((Integer)hashCode)});
            } else {
                Runtime.ArrayInitFunWithHub.emitCall((CodeGenTool)this.jsLTools, new IEmitter[]{JSEmitter.of(node), this.valueEmitter(firstEl), Emitter.of((String)hubVarName), Emitter.of((Integer)hashCode)});
            }
            this.jsLTools.genResolvedVarDeclPostfix(null);
        } else if (kind.isNumericInteger() && kind != JavaKind.Long) {
            int bits;
            int len = atype.length();
            int[] ints = JSBootImageHeapLowerer.packIntegerValues(atype, bits, switch (kind) {
                case JavaKind.Boolean -> {
                    bits = 1;
                    yield val -> val.asBoolean() ? 1 : 0;
                }
                case JavaKind.Byte -> {
                    bits = 8;
                    yield ObjectInspector.ValueType::asByte;
                }
                case JavaKind.Short -> {
                    bits = 16;
                    yield ObjectInspector.ValueType::asShort;
                }
                case JavaKind.Char -> {
                    bits = 16;
                    yield ObjectInspector.ValueType::asChar;
                }
                case JavaKind.Int -> {
                    bits = 32;
                    yield ObjectInspector.ValueType::asInt;
                }
                default -> throw JVMCIError.shouldNotReachHere((String)("Unhandled integer component type: " + String.valueOf(kind)));
            });
            boolean emitBase64ByteArray = false;
            if (((Boolean)WebImageOptions.EncodeImageHeapArraysBase64.getValue(HostedOptionValues.singleton())).booleanValue()) {
                int numBytes = len * bits / 8;
                float numBytesB64 = (float)numBytes * 4.0f / 3.0f;
                int numBytesLit = 0;
                for (int anInt : ints) {
                    numBytesLit = CodeGenTool.getEfficientIntLiteral((long)anInt).length() + 1;
                }
                boolean bl = emitBase64ByteArray = numBytesB64 < (float)numBytesLit;
            }
            if (emitBase64ByteArray) {
                this.emitBase64ByteArrayInitializer(node, hubVarName, len, bits, ints, hashCode);
            } else {
                this.masm.emitNewLine();
                Runtime.PackedArrayInitFunWitHubAndValue.emitReference(this.jsLTools);
                this.masm.emitText("(" + arrayName + ", ");
                this.masm.emitIntLiteral(len);
                this.masm.emitText(", ");
                this.masm.emitIntLiteral(bits);
                this.masm.emitText(", ");
                this.masm.emitText("[");
                for (int val2 : ints) {
                    this.masm.emitIntLiteral(val2);
                    this.masm.emitText(",");
                }
                this.masm.emitText("], " + hubVarName + ", ");
                this.masm.emitIntLiteral(hashCode);
                this.masm.emitText(")");
                this.jsLTools.genResolvedVarDeclPostfix(null);
            }
        } else {
            this.masm.emitNewLine();
            if (kind == JavaKind.Long) {
                Runtime.ArrayInitFunWithHubAndValueBigInt64.emitReference(this.jsLTools);
            } else {
                Runtime.ArrayInitFunWithHubAndValue.emitReference(this.jsLTools);
            }
            this.masm.emitText("(" + arrayName + ", ");
            this.masm.emitText("[");
            ArrayList elements = new ArrayList(atype.length());
            atype.elements.forEach(oo -> elements.add(this.valueEmitter((ObjectInspector.ObjectDefinition)oo)));
            this.jsLTools.genCommaList(elements);
            this.masm.emitText("], " + hubVarName + ", ");
            this.masm.emitIntLiteral(hashCode);
            this.masm.emitText(")");
            this.jsLTools.genResolvedVarDeclPostfix(null);
        }
    }

    protected void emitBase64ByteArrayInitializer(ConstantIdentityMapping.IdentityNode node, String hubVarName, int len, int bits, int[] ints, int hashCode) {
        int numBytes = (len * bits + 7) / 8;
        byte[] bytes = new byte[numBytes];
        for (int i = 0; i < ints.length; ++i) {
            int idx;
            int compound = ints[i];
            for (int j = 0; j < 4 && (idx = i * 4 + j) < numBytes; ++j) {
                bytes[idx] = (byte)(compound >> j * 8 & 0xFF);
            }
        }
        String b64 = Base64.getEncoder().encodeToString(bytes);
        this.masm.emitNewLine();
        Runtime.PackedArrayInitFunWitHubAndBase64Value.emitCall((CodeGenTool)this.jsLTools, new IEmitter[]{JSEmitter.of(node), Emitter.of((Integer)len), Emitter.of((Integer)bits), Emitter.stringLiteral((String)b64), Emitter.of((String)hubVarName), Emitter.of((Integer)hashCode)});
        this.jsLTools.genResolvedVarDeclPostfix(null);
    }

    protected IEmitter valueEmitter(ObjectInspector.ObjectDefinition odef) {
        if (odef instanceof ObjectInspector.ValueType) {
            ObjectInspector.ValueType valueType = (ObjectInspector.ValueType)odef;
            return JSEmitter.of(valueType);
        }
        if (odef instanceof ObjectInspector.MethodPointerType) {
            ObjectInspector.MethodPointerType methodPointerType = (ObjectInspector.MethodPointerType)odef;
            return JSEmitter.of(methodPointerType);
        }
        JavaConstant constant = odef.getConstant();
        if (constant.isNull()) {
            return Emitter.ofNull();
        }
        return JSEmitter.of(this.identityMapping.getIdentityNode(constant));
    }

    public static int getKindNum(JavaKind kind) {
        return kind.ordinal();
    }

    public static int getKindNum(HostedField f) {
        return JSBootImageHeapLowerer.getKindNum(f.getStorageKind());
    }
}

